/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class PowerAdcs
extends BaseSet {
    public static final int REG_POWER_ADCS = 0x600000;
    public static final int ADC_V6_VOLTAGE = 0;
    public static final int ADC_V6_CURRENT = 1;
    public static final int ADC_V9_VOLTAGE = 2;
    public static final int ADC_V9_CURRENT = 3;
    public static final int ADC_V24_VOLTAGE = 4;
    public static final int ADC_V24_CURRENT = 5;
    public static final int ADC_V40_VOLTAGE = 6;
    public static final int ADC_V40_CURRENT = 7;
    public static final int ADC_V5_VOLTAGE = 0;
    public static final int ADC_V5_CURRENT = 1;
    public static final int ADC_V7_VOLTAGE = 2;
    public static final int ADC_V7_CURRENT = 3;
    public static final int ADC_V15_VOLTAGE = 4;
    public static final int ADC_V15_CURRENT = 5;
    public static final int NUM_POWER_REGS_S = 8;
    public static final int ADC_DREB_VOLTAGE = 0;
    public static final int ADC_DREB_CURRENT = 1;
    public static final int ADC_CLKH_VOLTAGE = 2;
    public static final int ADC_CLKH_CURRENT = 3;
    public static final int ADC_DPHI_VOLTAGE = 4;
    public static final int ADC_DPHI_CURRENT = 5;
    public static final int ADC_HTR_VOLTAGE = 6;
    public static final int ADC_HTR_CURRENT = 7;
    public static final int ADC_ANA_VOLTAGE = 8;
    public static final int ADC_ANA_CURRENT = 9;
    public static final int ADC_OD_VOLTAGE = 10;
    public static final int ADC_OD_CURRENT = 11;
    public static final int NUM_POWER_REGS_C = 12;
    public static final int NUM_POWER_REGS_M = 12;
    public static final int ERROR_MASK = 65536;
    public static final int VALUE_MASK = 65535;
    public static final double VOLTAGE_SCALE = 0.0015625;
    public static final double CURRENT_SCALE_LO = 1.5625E-5;
    public static final double CURRENT_SCALE_HI = 5.208333333333333E-6;
    public static final double POWER_ERROR = -8888.0;

    public PowerAdcs() {
    }

    public PowerAdcs(RegClient reg) {
        super(reg);
    }

    @Override
    public void enable() throws REBException {
        this.getVersion(7);
        this.enable(3);
    }

    public void waitDone() throws REBException {
        this.getVersion(7);
        this.waitDone(3);
    }

    public long getTriggerTime() throws REBException {
        this.checkNotVersion(7, 0);
        return this.getTriggerTime(3);
    }

    public double readAdc(int adc) throws REBException {
        if (adc < 0 || adc >= this.getNumRegs()) {
            throw new REBException("Invalid power ADC number");
        }
        this.enable();
        this.waitDone();
        int value = this.read(0x600000 + adc);
        return (value & 0x10000) != 0 ? -8888.0 : this.getScale(adc) * (double)(value & 0xFFFF);
    }

    public double[] readAdcs() throws REBException {
        return this.readAdcs(0, this.getNumRegs());
    }

    public double[] readAdcs(int first, int count) throws REBException {
        if (first < 0 || count < 0 || first + count > this.getNumRegs()) {
            throw new REBException("Invalid power ADC range");
        }
        this.enable();
        this.waitDone();
        int[] rawData = new int[count];
        double[] data = new double[count];
        this.read(0x600000 + first, rawData);
        int j = 0;
        int adc = first;
        while (j < count) {
            int value = rawData[j];
            data[j] = (value & 0x10000) != 0 ? -8888.0 : this.getScale(adc) * (double)(value & 0xFFFF);
            ++j;
            ++adc;
        }
        return data;
    }

    public int getNumRegs() throws REBException {
        return this.getVersion(7) == 2 ? 12 : 8;
    }

    private double getScale(int adc) throws REBException {
        if ((adc & 1) == 0) {
            return 0.0015625;
        }
        if (this.getVersion(7) != 2) {
            return adc <= 3 ? 1.5625E-5 : 5.208333333333333E-6;
        }
        return 1.5625E-5;
    }
}

