/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class BoardDacs
extends BaseSet {
    public static final int REG_BOARD_DACS = 0x400000;
    public static final int REG_BOARD_DACS_0 = 0x500001;
    public static final int OFF_CLOCK_RAILS = 0;
    public static final int OFF_CS_GATE = 16;
    public static final int OFF_HEATER = 16;
    public static final int OFF_CABAC_ALT = 256;
    public static final int OFF_BIAS_GATE = 256;
    public static final int INC_STRIPS = 16;
    public static final int DACS_SET = 0;
    public static final int DACS_LOAD = 1;
    public static final int DAC_HAS_STRIP = 16;
    public static final int DAC_CLOCK_RAILS = 0;
    public static final int DAC_CS_GATE = 1;
    public static final int DAC_CABAC_ALT = 2;
    public static final int DAC_HEATER = 3;
    public static final int DAC_BIAS_GATE = 16;
    public static final int NUM_STRIPS = 3;
    public static final int CHAN_SCLK_L = 0;
    public static final int CHAN_SCLK_L_SH = 1;
    public static final int CHAN_SCLK_H = 2;
    public static final int CHAN_SCLK_H_SH = 3;
    public static final int CHAN_RG_L = 4;
    public static final int CHAN_RG_L_SH = 5;
    public static final int CHAN_RG_H = 6;
    public static final int CHAN_RG_H_SH = 7;
    public static final int CHAN_PCLK_L = 8;
    public static final int CHAN_PCLK_L_SH = 9;
    public static final int CHAN_PCLK_H = 10;
    public static final int CHAN_PCLK_H_SH = 11;
    public static final int CHAN_HEATER_1 = 12;
    public static final int CHAN_HEATER_2 = 13;
    public static final int CHAN_CSGATE_1 = 14;
    public static final int CHAN_CSGATE_2 = 15;
    public static final int CHAN_CSGATE_3 = 16;
    public static final int CHAN_FSB_CTRL = 17;
    public static final int CHAN_OD_CTRL = 18;
    public static final int CHAN_GD = 19;
    public static final int CHAN_RD = 20;
    public static final int CHAN_OG = 21;
    public static final int CHAN_OG_SH = 22;
    public static final int CHAN_OD = 23;
    public static final int CHAN_HEATER = 24;
    public static final int CHAN_CSGATE = 25;
    private static final Map<Integer, Integer> dacMap_0 = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> dacMap_1;
    private static final Map<Integer, Integer> dacMap_2;
    private static final Map<Integer, Integer> chanMap_0;
    private static final Map<Integer, Integer> chanMap_1;
    private static final Map<Integer, Integer> chanMap_2;

    public BoardDacs() {
    }

    public BoardDacs(RegClient reg) {
        super(reg);
    }

    public int getVersion() {
        try {
            return this.getVersion(6);
        }
        catch (REBException e) {
            return -1;
        }
    }

    public void loadAll() throws REBException {
        this.loadGlobal();
        this.loadStrip();
    }

    public void loadGlobal() throws REBException {
        for (Object dac : this.getDacMap().keySet()) {
            int iDac = (Integer)dac;
            if ((iDac & 0x10) != 0) continue;
            this.load(iDac);
        }
    }

    public void loadStrip() throws REBException {
        for (int strip = 0; strip < 3; ++strip) {
            this.loadStrip(strip);
        }
    }

    public void loadStrip(int strip) throws REBException {
        for (Object dac : this.getDacMap().keySet()) {
            int iDac = (Integer)dac;
            if ((iDac & 0x10) == 0) continue;
            this.load(strip, iDac);
        }
    }

    public void load(int dac) throws REBException {
        if ((dac & 0x10) == 0) {
            int version = this.getVersion();
            if (version == 0) {
                return;
            }
            this.write(this.getBase(version, dac, false) + 1, 0);
        } else {
            for (int strip = 0; strip < 3; ++strip) {
                this.load(strip, dac);
            }
        }
    }

    public void load(int strip, int dac) throws REBException {
        this.write(this.getBase(this.getVersion(), dac, true) + this.getStripOffset(strip) + 1, 0);
    }

    public void set(int chan, int value) throws REBException {
        int version = this.getVersion();
        int desc = this.getDescriptor(version, chan, false);
        this.write(this.getBase(version, desc >> 16, false) + 0, (desc & 0xFFFF) << 12 | value & 0xFFF);
    }

    public void set(int strip, int chan, int value) throws REBException {
        int version = this.getVersion();
        int desc = this.getDescriptor(version, chan, true);
        this.write(this.getBase(version, desc >> 16, true) + this.getStripOffset(strip) + 0, (desc & 0xFFFF) << 12 | value & 0xFFF);
    }

    private int getBase(int version, int dac, boolean hasStrip) throws REBException {
        Integer base = (Integer)this.getDacMap().get(dac);
        if (base == null || (dac & 0x10) != 0 != hasStrip) {
            throw new REBException("Invalid DAC number (" + dac + ")");
        }
        return (version == 0 ? 0x500001 : 0x400000) + base;
    }

    private int getStripOffset(int strip) throws REBException {
        if (strip < 0 || strip >= 3) {
            throw new REBException("Invalid strip number (" + strip + ")");
        }
        return 16 * strip;
    }

    private Map getDacMap() throws REBException {
        int version = this.getVersion();
        return version <= 1 ? dacMap_0 : (version == 2 ? dacMap_1 : dacMap_2);
    }

    private int getDescriptor(int version, int chan, boolean hasStrip) throws REBException {
        Map<Integer, Integer> map = version <= 1 ? chanMap_0 : (version == 2 ? chanMap_1 : chanMap_2);
        Integer desc = map.get(chan);
        if (desc == null || (desc >> 16 & 0x10) != 0 != hasStrip) {
            throw new REBException("Invalid channel number (" + chan + ")");
        }
        return desc;
    }

    static {
        dacMap_0.put(0, 0);
        dacMap_0.put(1, 16);
        dacMap_1 = new HashMap<Integer, Integer>();
        dacMap_1.put(0, 0);
        dacMap_1.put(1, 16);
        dacMap_1.put(2, 256);
        dacMap_2 = new HashMap<Integer, Integer>();
        dacMap_2.put(0, 0);
        dacMap_2.put(3, 16);
        dacMap_2.put(16, 256);
        chanMap_0 = new HashMap<Integer, Integer>();
        chanMap_0.put(0, 0);
        chanMap_0.put(2, 1);
        chanMap_0.put(4, 2);
        chanMap_0.put(6, 3);
        chanMap_0.put(8, 4);
        chanMap_0.put(10, 5);
        chanMap_0.put(12, 6);
        chanMap_0.put(13, 7);
        chanMap_0.put(14, 65536);
        chanMap_0.put(15, 65537);
        chanMap_0.put(16, 65538);
        chanMap_1 = new HashMap<Integer, Integer>();
        chanMap_1.put(0, 0);
        chanMap_1.put(1, 1);
        chanMap_1.put(2, 2);
        chanMap_1.put(3, 3);
        chanMap_1.put(4, 4);
        chanMap_1.put(5, 5);
        chanMap_1.put(6, 6);
        chanMap_1.put(7, 7);
        chanMap_1.put(8, 16);
        chanMap_1.put(9, 17);
        chanMap_1.put(10, 18);
        chanMap_1.put(11, 19);
        chanMap_1.put(14, 65536);
        chanMap_1.put(15, 65537);
        chanMap_1.put(16, 65538);
        chanMap_1.put(17, 65539);
        chanMap_1.put(12, 65540);
        chanMap_1.put(13, 65541);
        chanMap_1.put(18, 65542);
        chanMap_1.put(19, 131072);
        chanMap_1.put(20, 131073);
        chanMap_1.put(21, 131074);
        chanMap_1.put(22, 131075);
        chanMap_2 = new HashMap<Integer, Integer>();
        chanMap_2.put(2, 0);
        chanMap_2.put(0, 1);
        chanMap_2.put(1, 2);
        chanMap_2.put(10, 3);
        chanMap_2.put(8, 4);
        chanMap_2.put(9, 5);
        chanMap_2.put(6, 16);
        chanMap_2.put(4, 17);
        chanMap_2.put(5, 18);
        chanMap_2.put(24, 196608);
        chanMap_2.put(19, 0x100000);
        chanMap_2.put(23, 0x100001);
        chanMap_2.put(22, 0x100002);
        chanMap_2.put(21, 0x100003);
        chanMap_2.put(20, 0x100004);
        chanMap_2.put(25, 0x100005);
    }
}

