/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.Asic;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class Aspic
extends Asic {
    public static final int REG_ASPIC = 0xB00000;
    public static final int REG_ASPIC_LOAD = 0xB00000;
    public static final int REG_ASPIC_RESET = 0xB00001;
    public static final int REG_ASPIC_READ_0 = 0xB00011;
    public static final int REG_ASPIC_READ = 0xB00010;
    public static final int REG_ASPIC_NAP = 0xB00100;
    public static final int VALUE_MASK = 255;
    public static final int RC_MASK = 15;
    public static final int GAIN_POSN = 4;
    public static final int GAIN_INDEX = 0;
    public static final int RC_INDEX = 1;
    public static final int MODE_TM = 1;
    public static final int MODE_AF1 = 2;
    public static final int ADDR_GAIN_RC = 0;
    public static final int ADDR_CLAMP = 1;
    public static final int ADDR_MODES = 2;

    public Aspic() {
    }

    public Aspic(RegClient reg) {
        super(reg);
    }

    public int getVersion() {
        try {
            return this.getVersion(2, true);
        }
        catch (REBException e) {
            return -1;
        }
    }

    public void writeGainRc(int strips, int sides, int gain, int rc) throws REBException {
        this.writeParam(strips, sides, 0, rc & 0xF | gain << 4);
    }

    public void writeClamp(int strips, int sides, int clamp) throws REBException {
        this.writeParam(strips, sides, 1, clamp);
    }

    public void writeModes(int strips, int sides, int modes) throws REBException {
        this.writeParam(strips, sides, 2, modes);
    }

    public int[][] readGainRc(int strips, int side) throws REBException {
        int[] value = this.readParam(strips, side, 0);
        int[][] vals = new int[value.length][];
        for (int j = 0; j < value.length; ++j) {
            vals[j] = new int[]{value[j] >> 4, value[j] & 0xF};
        }
        return vals;
    }

    public int[] readClamp(int strips, int side) throws REBException {
        return this.readParam(strips, side, 1);
    }

    public int[] readModes(int strips, int side) throws REBException {
        return this.readParam(strips, side, 2);
    }

    public void reset(int strip) throws REBException {
        this.getVersion(2);
        this.write(0xB00001, strip);
    }

    public void setNapMode(boolean on) throws REBException {
        this.write(0xB00100, on ? 1 : 0);
    }

    public boolean isNapModeOn() throws REBException {
        return this.read(0xB00100) != 0;
    }

    private void writeParam(int strips, int sides, int addr, int value) throws REBException {
        this.getVersion(2);
        this.write(0xB00000, this.makeCommand(strips, sides, addr, 1, value & 0xFF));
    }

    private int[] readParam(int strips, int side, int addr) throws REBException {
        int regRead = this.getVersion(2) == 0 ? 0xB00011 : 0xB00010;
        this.write(0xB00000, this.makeCommand(strips, 1 << side, addr, 0, 0));
        int[] value = new int[Integer.bitCount(strips)];
        int k = 0;
        for (int j = 0; j < 3; ++j) {
            if ((strips >> j & 1) == 0) continue;
            value[k++] = this.read(regRead + j) & 0xFF;
        }
        return value;
    }
}

