package org.lsst.ccs.drivers.reb;

/**
 ******************************************************************************
 **
 **  Java interface to the PCI REB registers.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class RegClientPci implements RegClient.Impl {

    boolean first = true;

    RegClientPci() {
        if (first) {
            System.loadLibrary("RebPci");
            first = false;
        }
    }

    @Override
    public native long newRegClient(int id, String ifc);

    @Override
    public void deleteRegClient(long handle) {
        setClose(handle);
        deleteRegClient1(handle);
    }

    private native void setClose(long handle);

    private synchronized native void deleteRegClient1(long handle);

    @Override
    public int readReg(long handle, int address) throws REBException {
        int[] data = new int[1];
        readRegs(handle, address, data, 0, 1);
        return data[0];
    }

    @Override
    public synchronized native void readRegs(long handle, int address,
                                             int[] values, int offset,
                                             int count) throws REBException;

    @Override
    public void writeReg(long handle, int address, int value)
        throws REBException {
        int[] data = {value};
        writeRegs(handle, address, data, 0, 1);
    }

    @Override
    public synchronized native void writeRegs(long handle, int address,
                                              int[] values, int offset,
                                              int count) throws REBException;

    @Override
    public int updateReg(long handle, int address, int mask, int value)
        throws REBException {
        int oldValue = readReg(handle, address);
        writeReg(handle, address, (oldValue & ~mask) | (value & mask));
        return oldValue;
    }

}
