package org.lsst.ccs.drivers.reb;

/**
 ******************************************************************************
 **
 **  Java interface to the DAQ1 REB registers.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class RegClientDaq1 implements RegClient.Impl {

    static boolean first = true;
    int id;

    RegClientDaq1() {
        if (first) {
            System.loadLibrary("RebDaq1");
            first = false;
        }
    }

    @Override
    public long newRegClient(int id, String ifc) {
        this.id = id;
        return newRegClient1(id);
    }

    private native long newRegClient1(int id);

    @Override
    public native void deleteRegClient(long handle);

    @Override
    public synchronized int readReg(long handle, int address)
        throws REBException {
        int[] values = new int[1];
        readRegs1(handle, id, address, values, 0, 1);
        return values[0];
    }

    @Override
    public synchronized void readRegs(long handle, int address, int[] values,
                                      int offset, int count)
        throws REBException {
        readRegs1(handle, id, address, values, offset, count);
    }

    private native void readRegs1(long handle, int id, int address, int[] values,
                                  int offset, int count) throws REBException;

    @Override
    public synchronized void writeReg(long handle, int address, int value)
        throws REBException {
        int[] values = {value};
        writeRegs1(handle, id, address, values, 0, 1);
    }

    @Override
    public synchronized void writeRegs(long handle, int address, int[] values,
                                       int offset, int count)
        throws REBException {
        writeRegs1(handle, id, address, values, offset, count);
    }

    private native void writeRegs1(long handle, int id, int address,
                                   int[] values, int offset, int count)
        throws REBException;

    @Override
    public synchronized int updateReg(long handle, int address, int mask,
                                      int value) throws REBException {
        int[] values = {0};
        readRegs1(handle, id, address, values, 0, 1);
        int oldVal = values[0];
        values[0] = (values[0] & ~mask) | (value & mask);
        writeRegs1(handle, id, address, values, 0, 1);
        return oldVal;
    }

}
