package org.lsst.ccs.drivers.reb;

/**
 ******************************************************************************
 **
 **  Java interface to the DAQ0 REB registers.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class RegClientDaq0 implements RegClient.Impl {

    boolean first = true;

    RegClientDaq0() {
        if (first) {
            System.loadLibrary("RebDaq0");
            first = false;
        }
    }

    @Override
    public native long newRegClient(int id, String ifc);

    @Override
    public native void deleteRegClient(long handle);

    @Override
    public native int readReg(long handle, int address) throws REBException;

    @Override
    public native void readRegs(long handle, int address, int[] values,
                                int offset, int count) throws REBException;

    @Override
    public native void writeReg(long handle, int address, int value)
        throws REBException;

    @Override
    public native void writeRegs(long handle, int address, int[] values,
                                 int offset, int count) throws REBException;

    @Override
    public native int updateReg(long handle, int address, int mask, int value)
        throws REBException;
}
