package org.lsst.ccs.drivers.reb;

/**
 ******************************************************************************
 **
 **  Java interface to the PCI image client routines
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class ImageClientPci implements ImageClient.Impl  {

    boolean first = true;
    long client;
    boolean myRegClient;
    RegClient reg;

    ImageClientPci(RegClient reg) {
        if (first) {
            System.loadLibrary("RebPci");
            initSys();
            first = false;
        }
        if (reg != null) {
            this.reg = reg;
        }
        else {
            myRegClient = true;
            this.reg = new RegClient();
        }
    }

    private native static void initSys();

    @Override
    public void newImageClient(int id, String ifc) throws REBException {
        newImageClient1(id, ifc);
        try {
            if (myRegClient) {
               reg.open(RegClient.HDW_TYPE_PCI, id, ifc);
            }
        }
        catch (REBException e) {
            deleteImageClient1();
            throw e;
        }
    }

    public native void newImageClient1(int id, String ifc);

    @Override
    public void deleteImageClient() {
        if (myRegClient) {
            try {
                reg.close();
            }
            catch (REBException e) {
            }
        }
        deleteImageClient1();
    }

    public native void deleteImageClient1();

    @Override
    public Image waitForImage(Image image) {
        Image newImage = waitForImage1(image);
        try {
            int[] values = new int[3];
            reg.read(BaseSet.REG_SCHEMA, values);
            newImage.schema = values[0];
            newImage.version = values[1];
            newImage.address = values[2];
            newImage.tag = reg.readLong(BaseSet.REG_TRIG_TIME
                                          + 2 * BaseSet.RSET_SEQUENCER);
        }
        catch (REBException e) {
        }
        return newImage;
    }

    private native Image waitForImage1(Image image);

    @Override
    public native boolean getImage(Image image);

    @Override
    public native void reset();

    @Override
    public native void deleteImageMetadataRef(Image image);

}
