package org.lsst.ccs.drivers.reb;

/**
 ******************************************************************************
 **
 **  Java interface to the DAQ1 image client routines
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class ImageClientDaq1 implements ImageClient.Impl  {

    boolean first = true;
    long client, subscriber;

    ImageClientDaq1() {
        if (first) {
            System.loadLibrary("RebDaq1");
            initSys();
            first = false;
        }
    }

    private native static void initSys();

    @Override
    public native void newImageClient(int id, String ifc);

    @Override
    public native void deleteImageClient();

    @Override
    public native Image waitForImage(Image image);

    @Override
    public native boolean getImage(Image image);

    @Override
    public native void reset();

    @Override
    public native void deleteImageMetadataRef(Image image);

}
