/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class TempAdcs
extends BaseSet {
    public static final int REG_TEMP_ADCS = 0x600010;
    public static final int ADC_DREB_T1 = 0;
    public static final int ADC_DREB_T2 = 1;
    public static final int ADC_REB_T1 = 2;
    public static final int ADC_REB_T2 = 3;
    public static final int ADC_REB_T3 = 4;
    public static final int ADC_REB_T4 = 5;
    public static final int ADC_REB_T5 = 6;
    public static final int ADC_REB_T6 = 7;
    public static final int ADC_REB_T7 = 8;
    public static final int ADC_REB_T8 = 9;
    public static final int ADC_REB_T9 = 10;
    public static final int NUM_TEMP_REGS_S = 10;
    public static final int NUM_TEMP_REGS_S0 = 11;
    public static final int NUM_TEMP_REGS_C = 6;
    public static final int NUM_TEMP_REGS_M = 10;
    public static final int ERROR_MASK = 65536;
    public static final int VALUE_MASK = 65535;
    public static final double TEMP_SCALE = 0.0078125;
    public static final double TEMP_ERROR = -8888.0;

    public TempAdcs() {
    }

    public TempAdcs(RegClient reg) {
        super(reg);
    }

    @Override
    public void enable() throws REBException {
        this.getVersion(8);
        this.enable(4);
    }

    public void waitDone() throws REBException {
        this.getVersion(8);
        this.waitDone(4);
    }

    public long getTriggerTime() throws REBException {
        this.checkNotVersion(8, 0);
        return this.getTriggerTime(4);
    }

    public double readAdc(int adc) throws REBException {
        if (adc < 0 || adc >= this.getNumRegs()) {
            throw new REBException("Invalid temperature ADC number");
        }
        this.enable();
        this.waitDone();
        int value = this.read(0x600010 + adc);
        return (value & 0x10000) != 0 ? -8888.0 : 0.0078125 * (double)(value & 0xFFFF);
    }

    public double[] readAdcs() throws REBException {
        return this.readAdcs(0, this.getNumRegs());
    }

    public double[] readAdcs(int first, int count) throws REBException {
        if (first < 0 || count < 0 || first + count > this.getNumRegs()) {
            throw new REBException("Invalid temperature ADC range");
        }
        this.enable();
        this.waitDone();
        int[] rawData = new int[count];
        double[] data = new double[count];
        this.read(0x600010 + first, rawData);
        for (int j = 0; j < count; ++j) {
            int value = rawData[j];
            data[j] = (value & 0x10000) != 0 ? -8888.0 : 0.0078125 * (double)(value & 0xFFFF);
        }
        return data;
    }

    public int getNumRegs() throws REBException {
        int version = this.getVersion(8);
        return version >= 3 ? 10 : (version == 2 ? 6 : 11);
    }
}

