/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class ImageClientPci
implements ImageClient.Impl {
    boolean first = true;
    long client;
    boolean myRegClient;
    RegClient reg;

    ImageClientPci(RegClient reg) {
        if (this.first) {
            System.loadLibrary("RebPci");
            ImageClientPci.initSys();
            this.first = false;
        }
        if (reg != null) {
            this.reg = reg;
        } else {
            this.myRegClient = true;
            this.reg = new RegClient();
        }
    }

    private static native void initSys();

    @Override
    public void newImageClient(int id, String ifc) throws REBException {
        this.newImageClient1(id, ifc);
        try {
            if (this.myRegClient) {
                this.reg.open(2, id, ifc);
            }
        }
        catch (REBException e) {
            this.deleteImageClient1();
            throw e;
        }
    }

    public native void newImageClient1(int var1, String var2);

    @Override
    public void deleteImageClient() {
        if (this.myRegClient) {
            try {
                this.reg.close();
            }
            catch (REBException rEBException) {
                // empty catch block
            }
        }
        this.deleteImageClient1();
    }

    public native void deleteImageClient1();

    @Override
    public Image waitForImage(Image image) {
        Image newImage = this.waitForImage1(image);
        try {
            int[] values = new int[3];
            this.reg.read(0, values);
            newImage.schema = values[0];
            newImage.version = values[1];
            newImage.address = values[2];
            newImage.tag = this.reg.readLong(14);
        }
        catch (REBException rEBException) {
            // empty catch block
        }
        return newImage;
    }

    private native Image waitForImage1(Image var1);

    @Override
    public native boolean getImage(Image var1);

    @Override
    public native void reset();

    @Override
    public native void deleteImageMetadataRef(Image var1);
}

