/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.Asic;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class Cabac
extends Asic {
    public static final int REG_CABAC = 0x500000;
    public static final int REG_CABAC_LOAD = 0x500000;
    public static final int REG_CABAC_FETCH = 0x500001;
    public static final int REG_CABAC_RESET = 0x500001;
    public static final int REG_CABAC_RESET_0 = 0x500002;
    public static final int REG_CABAC_READ = 0x500010;
    public static final int CABAC_OFF_TOP = 16;
    public static final int CABAC_OFF_BOTTOM = 32;
    public static final int CABAC_OFF_WRITE = 0;
    public static final int CABAC_OFF_READ = 256;
    public static final int NUM_CABAC_REGS = 5;
    public static final int VALUE_MASK = 65535;
    public static final int REG_CABAC_POWER = 0xD00001;
    public static final int PWR_ENA_5V = 1;
    public static final int PWR_ENA_3V = 2;
    public static final int PWR_ENA_VEE = 4;
    public static final int PWR_ENA_B5V = 8;
    public static final int PWR_ENA_B3V = 16;
    public static final int CABAC_FLD_OD_EXP0 = 0;
    public static final int CABAC_FLD_OD_EXP1 = 1;
    public static final int CABAC_FLD_OD_RDO0 = 2;
    public static final int CABAC_FLD_OD_RDO1 = 3;
    public static final int CABAC_FLD_PCLK0 = 4;
    public static final int CABAC_FLD_PCLK1 = 5;
    public static final int CABAC_FLD_PCLK2 = 6;
    public static final int CABAC_FLD_PCLK3 = 7;
    public static final int CABAC_FLD_SCLK0 = 8;
    public static final int CABAC_FLD_SCLK1 = 9;
    public static final int CABAC_FLD_SCLK2 = 10;
    public static final int CABAC_FLD_RG = 11;
    public static final int CABAC_FLD_GD = 12;
    public static final int CABAC_FLD_OG = 13;
    public static final int CABAC_FLD_RD = 14;
    public static final int CABAC_FLD_SPH = 15;
    public static final int CABAC_FLD_SPL = 16;
    public static final int CABAC_FLD_MUX0 = 17;
    public static final int CABAC_FLD_MUX1 = 18;
    public static final int CABAC_FLD_PULSE = 19;
    public static final int CABAC_FLD_MUXE = 20;
    public static final int CABAC_FLD_SPARE = 15;
    public static final int CABAC_FLD_MUX = 16;
    public static final int CABAC_FLD_MUX_OFF = 17;
    public static final int CABAC_FLD_TEST = 18;
    public static final int CABAC_FLD_EXP_CLK = 20;
    public static final int CABAC_FLD_BIAS_HZ = 21;
    private static final int[] FIELD_LENGTHS = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 1, 1};
    private static final int[] FIELD_STARTS;
    private static final int[] FIELD_ADDRS;
    public static final int NUM_CABAC_FLDS_0 = 21;
    public static final int NUM_CABAC_FLDS = 22;

    static {
        int[] nArray = new int[21];
        nArray[1] = 8;
        nArray[2] = 16;
        nArray[3] = 24;
        nArray[4] = 32;
        nArray[5] = 40;
        nArray[6] = 48;
        nArray[7] = 56;
        nArray[8] = 64;
        nArray[9] = 72;
        nArray[10] = 80;
        nArray[11] = 88;
        nArray[12] = 96;
        nArray[13] = 104;
        nArray[14] = 112;
        nArray[15] = 120;
        nArray[16] = 128;
        nArray[17] = 136;
        nArray[18] = 140;
        nArray[19] = 144;
        nArray[20] = 145;
        FIELD_STARTS = nArray;
        int[] nArray2 = new int[22];
        nArray2[0] = 8;
        nArray2[1] = 9;
        nArray2[2] = 10;
        nArray2[3] = 11;
        nArray2[5] = 1;
        nArray2[6] = 2;
        nArray2[7] = 3;
        nArray2[8] = 4;
        nArray2[9] = 5;
        nArray2[10] = 6;
        nArray2[11] = 7;
        nArray2[12] = 13;
        nArray2[13] = 14;
        nArray2[14] = 12;
        nArray2[15] = 15;
        nArray2[16] = 16;
        nArray2[17] = 17;
        nArray2[18] = 20;
        nArray2[19] = 21;
        nArray2[20] = 18;
        nArray2[21] = 19;
        FIELD_ADDRS = nArray2;
    }

    public Cabac() {
    }

    public Cabac(RegClient reg) {
        super(reg);
    }

    public int getVersion() {
        try {
            return this.getVersion(1);
        }
        catch (REBException rEBException) {
            return -1;
        }
    }

    public void fetch(int strip) throws REBException {
        this.checkVersion(1, 0);
        this.checkStrip(strip);
        this.write(0x500001, strip);
    }

    public void load(int strip) throws REBException {
        this.checkVersion(1, 0);
        this.checkStrip(strip);
        this.write(0x500000, strip);
    }

    public void reset(int strip) throws REBException {
        int versn = this.getVersion(1);
        this.checkStrip(strip);
        this.write(versn == 0 ? 0x500002 : 0x500001, strip);
    }

    public int[] readRaw(int side) throws REBException {
        this.checkVersion(1, 0);
        int base = this.getBase(side) + 256;
        int[] values = new int[5];
        this.read(base, values);
        return values;
    }

    public void writeRaw(int side, int[] values) throws REBException {
        this.checkVersion(1, 0);
        int base = this.getBase(side) + 0;
        this.write(base, values);
    }

    public void copyRaw(int side) throws REBException {
        this.checkVersion(1, 0);
        int rbase = this.getBase(side) + 256;
        int wbase = this.getBase(side) + 0;
        int[] values = new int[5];
        this.read(rbase, values);
        this.write(wbase, values);
    }

    public void set(int side, int field, int value) throws REBException {
        this.checkVersion(1, 0);
        int base = this.getBase(side);
        this.checkField(field);
        int beg = FIELD_STARTS[field];
        int end = beg + FIELD_LENGTHS[field];
        int mask = (1 << end - beg) - 1;
        int regBeg = beg >> 5;
        int regEnd = end - 1 >> 5;
        int bitEnd = 32 - end & 0x1F;
        if (regEnd == regBeg) {
            this.updateReg(base, regBeg, mask << bitEnd, value << bitEnd);
        } else {
            this.updateReg(base, regBeg, mask >> 32 - bitEnd, value >> 32 - bitEnd);
            this.updateReg(base, regEnd, mask << bitEnd, value << bitEnd);
        }
    }

    public void set(int side, int[] value) throws REBException {
        this.checkVersion(1, 0);
        int base = this.getBase(side) + 0;
        int[] regs = new int[5];
        int j = 0;
        while (j < regs.length) {
            regs[j] = 0;
            ++j;
        }
        j = 0;
        while (j < 21) {
            int beg = FIELD_STARTS[j];
            int end = beg + FIELD_LENGTHS[j];
            int val = value[j] & (1 << end - beg) - 1;
            int regBeg = beg >> 5;
            int regEnd = end - 1 >> 5;
            int bitEnd = 32 - end & 0x1F;
            if (regEnd == regBeg) {
                int n = regBeg;
                regs[n] = regs[n] | val << bitEnd;
            } else {
                int n = regBeg;
                regs[n] = regs[n] | val >> 32 - bitEnd;
                int n2 = regEnd;
                regs[n2] = regs[n2] | val << bitEnd;
            }
            ++j;
        }
        this.write(base, regs);
    }

    public void set(int side, int first, int count, int[] value) throws REBException {
        this.checkVersion(1, 0);
        int base = this.getBase(side);
        this.checkField(first, count);
        int[] regs = new int[5];
        int[] masks = new int[5];
        int j = 0;
        while (j < regs.length) {
            regs[j] = 0;
            masks[j] = 0;
            ++j;
        }
        j = 0;
        while (j < count) {
            int beg = FIELD_STARTS[first + j];
            int end = beg + FIELD_LENGTHS[first + j];
            int mask = (1 << end - beg) - 1;
            int val = value[j] & mask;
            int regBeg = beg >> 5;
            int regEnd = end - 1 >> 5;
            int bitEnd = 32 - end & 0x1F;
            if (regEnd == regBeg) {
                int n = regBeg;
                regs[n] = regs[n] | val << bitEnd;
                int n2 = regBeg;
                masks[n2] = masks[n2] | mask << bitEnd;
            } else {
                int n = regBeg;
                regs[n] = regs[n] | val >> 32 - bitEnd;
                int n3 = regEnd;
                regs[n3] = regs[n3] | val << bitEnd;
                int n4 = regBeg;
                masks[n4] = masks[n4] | mask >> 32 - bitEnd;
                int n5 = regEnd;
                masks[n5] = masks[n5] | mask << bitEnd;
            }
            ++j;
        }
        j = 0;
        while (j < regs.length) {
            if (masks[j] != 0) {
                if (masks[j] == -1) {
                    this.write(base + 0 + j, regs[j]);
                } else {
                    this.updateReg(base, j, masks[j], regs[j]);
                }
            }
            ++j;
        }
    }

    public int get(int side, int field) throws REBException {
        return this.get(side, field, 1)[0];
    }

    public int[] get(int side) throws REBException {
        return this.get(side, 0, 21);
    }

    public int[] get(int side, int first, int count) throws REBException {
        this.checkVersion(1, 0);
        int base = this.getBase(side) + 256;
        this.checkField(first, count);
        int[] regs = new int[5];
        int[] value = new int[count];
        this.read(base, regs);
        int j = 0;
        while (j < count) {
            int beg = FIELD_STARTS[first + j];
            int end = beg + FIELD_LENGTHS[first + j];
            int mask = (1 << end - beg) - 1;
            int regBeg = beg >> 5;
            int regEnd = end - 1 >> 5;
            int bitEnd = 32 - end & 0x1F;
            value[j] = regEnd == regBeg ? regs[regBeg] >> bitEnd & mask : (regs[regBeg] << 32 - bitEnd | regs[regEnd] >>> bitEnd) & mask;
            ++j;
        }
        return value;
    }

    public void writeField(int strips, int sides, int field, int value) throws REBException {
        this.writeField(strips, sides, field, 1, new int[]{value});
    }

    public void writeField(int strips, int sides, int[] value) throws REBException {
        this.writeField(strips, sides, 0, 22, value);
    }

    public void writeField(int strips, int sides, int first, int count, int[] value) throws REBException {
        this.checkVersion(1, 1);
        this.checkField(first, count);
        int j = 0;
        while (j < count) {
            this.write(0x500000, this.makeCommand(strips, sides, FIELD_ADDRS[first + j], 1, value[j] & 0xFFFF));
            ++j;
        }
    }

    public int[] readField(int strips, int side, int field) throws REBException {
        int[][] value = this.readField(strips, side, field, 1);
        int[] value0 = new int[value.length];
        int j = 0;
        while (j < value.length) {
            value0[j] = value[j][0];
            ++j;
        }
        return value0;
    }

    public int[][] readField(int strips, int side) throws REBException {
        return this.readField(strips, side, 0, 22);
    }

    public int[][] readField(int strips, int side, int first, int count) throws REBException {
        this.checkVersion(1, 1);
        this.checkSide(side);
        this.checkField(first, count);
        int[][] value = new int[Integer.bitCount(strips)][count];
        int j = 0;
        while (j < count) {
            this.write(0x500000, this.makeCommand(strips, 1 << side, FIELD_ADDRS[first + j], 0, 0));
            int k = 0;
            int l = 0;
            while (k < 3) {
                if ((strips >> k & 1) != 0) {
                    value[l++][j] = this.read(0x500010 + k);
                }
                ++k;
            }
            ++j;
        }
        return value;
    }

    public int getNumFields() throws REBException {
        return this.getVersion(1) == 0 ? 21 : 22;
    }

    public void setRegulator(int enables) throws REBException {
        this.checkVersion(1, 1);
        this.write(0xD00001, enables);
    }

    public int getRegulator() throws REBException {
        this.checkVersion(1, 1);
        return this.read(0xD00001);
    }

    private int getBase(int side) throws REBException {
        this.checkSide(side);
        return 0x500000 + (side == 1 ? 32 : 16);
    }

    private void checkStrip(int strip) throws REBException {
        if (strip < 0 || strip >= 3) {
            throw new REBException("Invalid CABAC strip number");
        }
    }

    private void checkSide(int side) throws REBException {
        if (side != 1 && side != 0) {
            throw new REBException("Invalid CABAC side number");
        }
    }

    private void checkField(int field) throws REBException {
        if (field < 0 || field >= this.getNumFields()) {
            throw new REBException("Invalid CABAC field number");
        }
    }

    private void checkField(int first, int count) throws REBException {
        if (first < 0 || count < 0 || first + count > this.getNumFields()) {
            throw new REBException("Invalid CABAC field number");
        }
    }

    private void updateReg(int base, int reg, int mask, int value) throws REBException {
        this.write(base + 0 + reg, this.read(base + 256 + reg) & ~mask | value & mask);
    }
}

