/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.REBException;

public class TestImage
implements ImageClient.Listener {
    private static final String CUP = "\u001b[A";
    private static final String NL = "\n";
    private final ImageClient imc = new ImageClient();
    private final BaseSet reg = new BaseSet();
    private int rebId = -1;
    private int imgLength = -1;
    private int imgOffset = 0;
    private boolean listening;
    private boolean showTime;
    private boolean reuseImage = true;
    private Image image = new Image();

    @Command(name="connect", description="Connect to a REB")
    public void connect(@Argument(name="id", description="REB ID") int id) throws REBException {
        this.imc.open(id);
        this.reg.open(id);
        this.rebId = id;
    }

    @Command(name="connect", description="Connect to a REB")
    public void connect(@Argument(name="id", description="REB ID") int id, @Argument(name="ifcname", description="Network interface name") String ifcName) throws REBException {
        this.imc.open(id, ifcName);
        this.reg.open(id, ifcName);
        this.rebId = id;
    }

    @Command(name="disconnect", description="Disconnect from a REB")
    public void disconnect() throws REBException {
        this.rebId = -1;
        this.imc.close();
        this.reg.close();
    }

    @Command(name="reuse", description="Enable or disable image buffer re-use")
    public void reuse(@Argument(name="action", description="Action to take") OnOff action) {
        this.reuseImage = action == OnOff.ON;
    }

    @Command(name="time", description="Enable or disable time display")
    public void time(@Argument(name="action", description="Action to take") OnOff action) {
        this.showTime = action == OnOff.ON;
    }

    @Command(name="listen", description="Enable or disable the listener")
    public String listen(@Argument(name="action", description="Action to take") OnOff action) {
        String result = this.checkConnect();
        if (result != null) {
            return result;
        }
        if (action.ordinal() == 0) {
            this.listening = true;
            this.imc.setListener(this, this.reuseImage ? this.image : null);
        } else {
            this.listening = false;
            this.imc.clearListener();
        }
        return CUP;
    }

    @Command(name="region", description="Set the image display region")
    public void region(@Argument(name="length", description="The region length (pixels)") int length) {
        this.imgLength = length;
    }

    @Command(name="region", description="Set the image display region")
    public void region(@Argument(name="length", description="The region length (pixels)") int length, @Argument(name="offset", description="The offset to the region (pixels)") int offset) {
        this.imgLength = length;
        this.imgOffset = offset;
    }

    @Command(name="show", description="Display parameters")
    public String show() {
        return String.format("REB ID       = %-8s  Image length = %s\nImage offset = %-8s  Listener on  = %s\nShow time    = %-8s  Reuse image  = %s", this.rebId, this.imgLength, this.imgOffset, this.listening, this.showTime, this.reuseImage);
    }

    @Command(name="wait", description="Wait for an image to arrive")
    public String awaitImage() throws REBException {
        String result = this.checkConnect();
        if (result != null) {
            return result;
        }
        result = this.checkListen();
        if (result != null) {
            return result;
        }
        this.image = this.imc.awaitImage(this.reuseImage ? this.image : null);
        if (this.showTime) {
            long cTime = this.reg.getTime();
            long tTime = this.reg.getTriggerTime(2);
            result = "Elapsed time = " + (cTime - tTime) + " msec";
        }
        String text = this.formatMetadata(this.image, "Got metadata", false);
        return result == null ? text : String.valueOf(result) + NL + text;
    }

    @Command(name="read", description="Read an image")
    public String read() throws REBException {
        String result = this.checkConnect();
        if (result != null) {
            return result;
        }
        result = this.checkListen();
        if (result != null) {
            return result;
        }
        long start = System.currentTimeMillis();
        boolean imgOkay = this.imc.readImage(this.image);
        if (this.showTime) {
            result = "Elapsed time = " + (System.currentTimeMillis() - start) + " msec";
        }
        if (!imgOkay) {
            String text = "Error reading image data";
            result = result == null ? text : String.valueOf(result) + NL + text;
        }
        return result == null ? CUP : result;
    }

    @Command(name="display", description="Display image data")
    public String display(@Argument(name="length", description="The display region length (pixels)") int length) {
        String text = this.formatImage(this.image, 0, length);
        return text == null ? CUP : text;
    }

    @Command(name="display", description="Display image data")
    public String display(@Argument(name="length", description="The display region length (pixels)") int length, @Argument(name="offset", description="The offset to the display region (pixels)") int offset) {
        String text = this.formatImage(this.image, offset, length);
        return text == null ? CUP : text;
    }

    @Command(name="metadata", description="Display image metadata")
    public String metadata() {
        return this.formatMetadata(this.image, "Metadata", true);
    }

    @Command(name="reset", description="Reset the front end")
    public void reset() throws REBException {
        this.imc.resetFrontEnd();
    }

    @Override
    public void processImage(Image img) {
        String text;
        this.image = img;
        if (this.showTime) {
            try {
                long cTime = this.reg.getTime();
                long tTime = this.reg.getTriggerTime(2);
                System.out.println("Elapsed time = " + (cTime - tTime) + " msec");
            }
            catch (REBException rEBException) {}
        }
        System.out.println(this.formatMetadata(this.image, "Got image", true));
        if (this.image.getData() != null && (text = this.formatImage(this.image, this.imgOffset, this.imgLength)) != null) {
            System.out.println(text);
        }
    }

    private String formatMetadata(Image img, String caption, boolean showValid) {
        StringBuilder blanks = new StringBuilder(caption.length());
        int j = 0;
        while (j < caption.length()) {
            blanks.append(" ");
            ++j;
        }
        Object[] objectArray = new Object[12];
        objectArray[0] = caption;
        objectArray[1] = this.image.getTag();
        objectArray[2] = this.image.getLength();
        objectArray[3] = this.image.getFormat();
        objectArray[4] = blanks;
        objectArray[5] = this.image.getSchema();
        objectArray[6] = this.image.getVersion();
        objectArray[7] = this.image.getAddress();
        objectArray[8] = blanks;
        objectArray[9] = this.image.getCluster();
        objectArray[10] = this.image.getElement();
        objectArray[11] = showValid ? (this.image.getData() != null ? ", valid" : ", invalid") : "";
        return String.format("%s: tag = %016x, length = %s, format = %s,\n%s  schema = %08x,  version = %08x, address = %s,\n%s  cluster = %s, element = %s%s", objectArray);
    }

    private String formatImage(Image img, int offset, int count) {
        if (count < 0) {
            return null;
        }
        ByteBuffer buff = img.getData();
        if (buff == null) {
            return "Image contains no valid data";
        }
        offset = offset < 0 ? 0 : offset;
        int iCount = img.getLength();
        if (count == 0 || count + offset > iCount) {
            count = iCount - offset;
        }
        if (count <= 0) {
            return null;
        }
        StringBuilder text = new StringBuilder();
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.position(4 * offset);
        int j = 0;
        while (j < count) {
            if ((j & 3) == 0) {
                if (j != 0) {
                    text.append(NL);
                }
                text.append(String.format("%08x:", offset + j));
            }
            text.append(String.format(" %08x", buff.getInt()));
            ++j;
        }
        return text.toString();
    }

    private String checkConnect() {
        return this.imc != null ? null : "No REB connected";
    }

    private String checkListen() {
        return !this.listening ? null : "Listener is active";
    }

    public static enum OnOff {
        ON,
        OFF;

    }
}

