/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.REBException;

public class ImageClient {
    private static final int RUNNING = 0;
    private static final int CLOSING = 1;
    private static final int ENDING = 2;
    private long client;
    private long subscriber;
    private ReadThread reader;
    private Listener imgListener;
    private Image listenImage;

    static {
        System.loadLibrary("Reb");
        ImageClient.initSys();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.deleteImageClient();
    }

    public void open(int id) throws REBException {
        this.open(id, null);
    }

    public void open(int id, String ifc) throws REBException {
        if (this.client != 0L) {
            throw new REBException("Image connection already open");
        }
        this.newImageClient(id, ifc);
        if (this.imgListener != null) {
            this.reader = new ReadThread(this.imgListener, this.listenImage);
            this.reader.setDaemon(true);
            this.reader.start();
        }
    }

    public void close() throws REBException {
        this.checkOpen();
        if (this.reader != null) {
            this.reader.setState(2);
            this.reader = null;
        }
        this.deleteImageClient();
    }

    public Image awaitImage(Image image) throws REBException {
        this.checkOpen();
        return this.waitForImage(image);
    }

    public boolean readImage(Image image) throws REBException {
        this.checkOpen();
        return this.getImage(image);
    }

    public static native void deleteImageMetadataRef(Image var0);

    public void resetFrontEnd() throws REBException {
        this.checkOpen();
        this.reset();
    }

    public void setListener(Listener listener, Image image) {
        this.clearListener();
        this.imgListener = listener;
        this.listenImage = image;
        if (this.client != 0L) {
            this.reader = new ReadThread(listener, image);
            this.reader.setDaemon(true);
            this.reader.start();
        }
    }

    public void clearListener() {
        if (this.reader != null) {
            this.reader.setState(2);
            this.reader = null;
        }
        this.imgListener = null;
        this.listenImage = null;
    }

    private static native void initSys();

    private native void newImageClient(int var1, String var2);

    private native void deleteImageClient();

    private native Image waitForImage(Image var1);

    private native boolean getImage(Image var1);

    private native void reset();

    private void checkOpen() throws REBException {
        if (this.client == 0L) {
            throw new REBException("Image connection not open");
        }
    }

    public static interface Listener {
        public void processImage(Image var1);
    }

    public class ReadThread
    extends Thread {
        Listener listener;
        Image listenImage;
        int state = 0;

        public ReadThread(Listener lstnr, Image image) {
            this.listener = lstnr;
            this.listenImage = image;
        }

        @Override
        public void run() {
            while (this.state == 0) {
                Image image = ImageClient.this.waitForImage(this.listenImage);
                if (this.state != 0) break;
                ImageClient.this.getImage(image);
                Listener l = this.listener;
                if (this.state != 0) break;
                l.processImage(image);
            }
            if (this.state == 1) {
                ImageClient.this.deleteImageClient();
            }
        }

        public void setState(int newState) {
            this.state = newState;
        }
    }
}

