/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class BoardDacs
extends BaseSet {
    public static final int REG_BOARD_DACS = 0x400000;
    public static final int REG_BOARD_DACS_0 = 0x500001;
    public static final int OFF_CLOCK_RAILS = 0;
    public static final int OFF_CS_GATE = 16;
    public static final int OFF_CABAC_ALT = 256;
    public static final int DACS_SET = 0;
    public static final int DACS_LOAD = 1;
    public static final int DAC_CLOCK_RAILS = 0;
    public static final int DAC_CS_GATE = 1;
    public static final int DAC_CABAC_ALT = 2;
    public static final int NUM_BOARD_DACS = 2;
    public static final int NUM_BOARD_DACS_2 = 3;
    public static final int CHAN_SCLK_L = 0;
    public static final int CHAN_SCLK_L_SH = 1;
    public static final int CHAN_SCLK_H = 2;
    public static final int CHAN_SCLK_H_SH = 3;
    public static final int CHAN_RG_L = 4;
    public static final int CHAN_RG_L_SH = 5;
    public static final int CHAN_RG_H = 6;
    public static final int CHAN_RG_H_SH = 7;
    public static final int CHAN_PCLK_L = 8;
    public static final int CHAN_PCLK_L_SH = 9;
    public static final int CHAN_PCLK_H = 10;
    public static final int CHAN_PCLK_H_SH = 11;
    public static final int CHAN_HEATER_1 = 12;
    public static final int CHAN_HEATER_2 = 13;
    public static final int CHAN_CSGATE_1 = 14;
    public static final int CHAN_CSGATE_2 = 15;
    public static final int CHAN_CSGATE_3 = 16;
    public static final int CHAN_FSB_CTRL = 17;
    public static final int CHAN_OD_CTRL = 18;
    public static final int CHAN_GD = 19;
    public static final int CHAN_RD = 20;
    public static final int CHAN_OG = 21;
    public static final int CHAN_OG_SH = 22;
    private static final Map<Integer, Integer> dacMap = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> chanMap_0;
    private static final Map<Integer, Integer> chanMap_1;

    static {
        dacMap.put(0, 0);
        dacMap.put(1, 16);
        dacMap.put(2, 256);
        chanMap_0 = new HashMap<Integer, Integer>();
        chanMap_0.put(0, 0);
        chanMap_0.put(2, 1);
        chanMap_0.put(4, 2);
        chanMap_0.put(6, 3);
        chanMap_0.put(8, 4);
        chanMap_0.put(10, 5);
        chanMap_0.put(12, 6);
        chanMap_0.put(13, 7);
        chanMap_0.put(14, 65536);
        chanMap_0.put(15, 65537);
        chanMap_0.put(16, 65538);
        chanMap_1 = new HashMap<Integer, Integer>();
        chanMap_1.put(0, 0);
        chanMap_1.put(1, 1);
        chanMap_1.put(2, 2);
        chanMap_1.put(3, 3);
        chanMap_1.put(4, 4);
        chanMap_1.put(5, 5);
        chanMap_1.put(6, 6);
        chanMap_1.put(7, 7);
        chanMap_1.put(8, 16);
        chanMap_1.put(9, 17);
        chanMap_1.put(10, 18);
        chanMap_1.put(11, 19);
        chanMap_1.put(14, 65536);
        chanMap_1.put(15, 65537);
        chanMap_1.put(16, 65538);
        chanMap_1.put(17, 65539);
        chanMap_1.put(12, 65540);
        chanMap_1.put(13, 65541);
        chanMap_1.put(18, 65542);
        chanMap_1.put(19, 131072);
        chanMap_1.put(20, 131073);
        chanMap_1.put(21, 131074);
        chanMap_1.put(22, 131075);
    }

    public BoardDacs() {
    }

    public BoardDacs(RegClient reg) {
        super(reg);
    }

    public int getVersion() {
        try {
            return this.getVersion(6);
        }
        catch (REBException rEBException) {
            return -1;
        }
    }

    public void load() throws REBException {
        int version = this.getVersion(6);
        int ndacs = version <= 1 ? 2 : 3;
        int dac = 0;
        while (dac < ndacs) {
            this.load(dac);
            ++dac;
        }
    }

    public void load(int dac) throws REBException {
        int version = this.getVersion(6);
        if (version == 0) {
            return;
        }
        int base = this.getBase(version, dac);
        this.write(base + 1, 0);
    }

    public void set(int chan, int value) throws REBException {
        int version = this.getVersion(6);
        Integer desc = (version <= 1 ? chanMap_0 : chanMap_1).get(chan);
        if (desc == null) {
            throw new REBException("Invalid channel number");
        }
        int base = this.getBase(version, desc >> 16);
        this.write(base + 0, (desc & 0xFFFF) << 12 | value & 0xFFF);
    }

    private int getBase(int version, int dac) throws REBException {
        int ndacs;
        int n = ndacs = version <= 1 ? 2 : 3;
        if (dac < 0 || dac >= ndacs) {
            throw new REBException("Invalid DAC number");
        }
        return (version == 0 ? 0x500001 : 0x400000) + dacMap.get(dac);
    }
}

