/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class TempRtds
extends BaseSet {
    public static final int REG_RTD_COMMAND = 0x700000;
    public static final int REG_RTD_REPLY = 0x700001;
    public static final int NUM_RTD_TEMPS = 4;

    public TempRtds() {
    }

    public TempRtds(RegClient reg) {
        super(reg);
    }

    public void writeCommand(int value) throws REBException {
        this.write(0x700000, value);
    }

    public int readReply() throws REBException {
        return this.read(0x700001);
    }

    public double readRtd(int rtd) throws REBException {
        this.getVersion(10);
        if (rtd < 0 || rtd >= 4) {
            throw new REBException("Invalid temperature RTD number");
        }
        return 0.0;
    }
}

