/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class BaseSet
extends RegClient {
    public static final int RSET_STATUS = 0;
    public static final int RSET_TIME_BASE = 1;
    public static final int RSET_SEQUENCER = 2;
    public static final int RSET_POWER_ADCS = 3;
    public static final int RSET_TEMP_ADCS = 4;
    public static final int RSET_FAST_ADCS = 5;
    public static final int REG_SCHEMA = 0;
    public static final int REG_VERSION = 1;
    public static final int REG_ID = 2;
    public static final int REG_TIME_BASE = 4;
    public static final int REG_STATE = 8;
    public static final int REG_TRIGGER = 9;
    public static final int REG_TRIG_TIME = 10;
    public static final int REG_SN_REB_START = 0x800000;
    public static final int REG_SN_REB_VALUE = 0x800001;
    public static final int REG_SN_DREB_START = 0x800010;
    public static final int REG_SN_DREB_VALUE = 0x800011;
    public static final int REG_DCDC_SYNC = 0x900000;
    public static final int OPTN_SEQUENCER = 0;
    public static final int OPTN_CABAC = 1;
    public static final int OPTN_ASPIC = 2;
    public static final int OPTN_REB_SN = 3;
    public static final int OPTN_DREB_SN = 4;
    public static final int OPTN_DCDC_SYNC = 5;
    public static final int OPTN_BOARD_DACS = 6;
    public static final int OPTN_BOARD_POWER = 7;
    public static final int OPTN_BOARD_TEMP = 8;
    public static final int OPTN_STATUS = 9;
    public static final int OPTN_CCD_TEMP = 10;
    public static final int OPTN_ASIC_TEMP = 11;
    public static final int OPTN_FAST_ADCS = 12;
    public static final int OPTN_BACK_BIAS = 13;
    public static final int VERSION_UNSET = -3;
    public static final int VERSION_UNKNOWN = -2;
    public static final int VERSION_UNSUPP = -1;
    public static final int VERSION_0 = 0;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final int VERSION_5 = 5;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_SCIENCE = 0;
    public static final int TYPE_CORNER = 1;
    public static final int CLOCK_PERIOD_0 = 5;
    public static final int CLOCK_PERIOD_1 = 10;
    public static final long SN_READ_OKAY = 0x1000000000000L;
    public static final long SN_READ_ERROR = 0x2000000000000L;
    public static final long SN_READ_TIMEOUT = 0x4000000000000L;
    public static final long SN_VALUE_MASK = 0xFFFFFFFFFFFFL;
    private static final int WAIT_TIMEOUT = 1000;
    private int fwVersion = -3;
    private int handleInst;
    private final Map<Integer, Integer> versionMap = new HashMap<Integer, Integer>();

    public BaseSet() {
    }

    public BaseSet(RegClient reg) {
        this.handle = reg.handle;
    }

    public int getFwVersion() throws REBException {
        this.setVersions();
        return this.fwVersion;
    }

    public int getVersion(int option) throws REBException {
        return this.getVersion(option, false);
    }

    public int getVersion(int option, boolean unsOkay) throws REBException {
        this.setVersions();
        Integer version = this.versionMap.get(option);
        if (version == null) {
            throw new REBException("Unrecognized option");
        }
        if (version == -2) {
            throw new REBException("Unknown firmware version");
        }
        if (version == -1 && !unsOkay) {
            throw new REBException("Option not supported by the firmware");
        }
        return version;
    }

    public boolean isVersion(int option, int ... version) throws REBException {
        int currVersion = this.getVersion(option, true);
        int[] nArray = version;
        int n = version.length;
        int n2 = 0;
        while (n2 < n) {
            int testVersion = nArray[n2];
            if (testVersion == currVersion) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void checkVersion(int option, int ... version) throws REBException {
        if (!this.isVersion(option, version)) {
            throw new REBException("Incompatible firmware version");
        }
    }

    public void checkNotVersion(int option, int ... version) throws REBException {
        if (this.isVersion(option, version)) {
            throw new REBException("Incompatible firmware version");
        }
    }

    public void enable() throws REBException {
        this.enable(1);
    }

    public void disable() throws REBException {
        this.disable(1);
    }

    public long getTimeRaw() throws REBException {
        return this.readLong(4);
    }

    public long getTime() throws REBException {
        return (long)this.getPeriod() * this.getTimeRaw() / 1000000L;
    }

    public void setTimeRaw(long time) throws REBException {
        this.writeLong(4, time);
    }

    public void setTime(long time) throws REBException {
        this.setTimeRaw(1000000L * time / (long)this.getPeriod());
    }

    public void setTime() throws REBException {
        this.setTime(System.currentTimeMillis());
    }

    public void enable(int regSet) throws REBException {
        this.write(9, this.read(8) & 3 | 1 << regSet);
    }

    public void disable(int regSet) throws REBException {
        this.write(9, this.read(8) & 3 & ~(1 << regSet));
    }

    public void waitDone(int regSet) throws REBException {
        long limit = System.currentTimeMillis() + 1000L;
        boolean busy = true;
        while (busy && System.currentTimeMillis() < limit) {
            boolean bl = busy = (this.read(8) & 1 << regSet) != 0;
        }
        if (busy) {
            throw new REBException("Completion wait timeout");
        }
    }

    public long getTriggerTimeRaw(int regSet) throws REBException {
        return this.readLong(10 + 2 * regSet);
    }

    public long getTriggerTime(int regSet) throws REBException {
        return (long)this.getPeriod() * this.getTriggerTimeRaw(regSet) / 1000000L;
    }

    public long getRebSerial() throws REBException {
        this.getVersion(3);
        this.write(0x800000, 0);
        long value = this.readLong(0x800001);
        if ((value & 0x1000000000000L) == 0L) {
            String problem = (value & 0x2000000000000L) != 0L ? "error" : "timeout";
            throw new REBException("Serial number read " + problem);
        }
        return value & 0xFFFFFFFFFFFFL;
    }

    public long getDrebSerial() throws REBException {
        this.getVersion(4);
        this.write(0x800010, 0);
        long value = this.readLong(0x800011);
        if ((value & 0x1000000000000L) == 0L) {
            String problem = (value & 0x2000000000000L) != 0L ? "error" : "timeout";
            throw new REBException("Serial number read " + problem);
        }
        return value & 0xFFFFFFFFFFFFL;
    }

    public void setDcdcSync(boolean enable) throws REBException {
        this.getVersion(5);
        this.write(0x900000, enable ? 1 : 0);
    }

    public boolean isDcdcSync() throws REBException {
        this.getVersion(5);
        return (this.read(0x900000) & 1) != 0;
    }

    public void setVersions() throws REBException {
        try {
            this.checkOpen();
        }
        catch (REBException e) {
            this.fwVersion = -3;
            throw e;
        }
        if (this.fwVersion != -3 && this.handleInst == this.handle.instance) {
            return;
        }
        this.handleInst = this.handle.instance;
        int schema = this.read(0);
        int hwVersion = this.read(1) >> 16 & 0xFFFF;
        if (schema == 15851008) {
            this.fwVersion = 0;
        } else if (hwVersion == 45084) {
            if (schema == 1) {
                this.fwVersion = 1;
            } else if (schema == 2) {
                this.fwVersion = 2;
            } else if (schema == 3) {
                this.fwVersion = 3;
            } else if (schema == 4) {
                this.fwVersion = 4;
            }
        } else {
            this.fwVersion = hwVersion == 45086 ? 5 : -2;
        }
        int version = this.fwVersion < 0 ? -2 : (this.fwVersion == 0 ? 0 : (this.fwVersion <= 3 ? 1 : (this.fwVersion <= 4 ? 2 : 3)));
        this.versionMap.put(0, version);
        version = this.fwVersion < 0 ? -2 : (this.fwVersion < 2 ? -1 : (this.fwVersion < 5 ? 0 : 1));
        this.versionMap.put(1, version);
        version = this.fwVersion < 0 ? -2 : (this.fwVersion < 4 ? -1 : 0);
        this.versionMap.put(2, version);
        version = this.fwVersion < 0 ? -2 : (this.fwVersion < 3 ? -1 : 0);
        this.versionMap.put(3, version);
        this.versionMap.put(5, version);
        version = this.fwVersion < 0 ? -2 : (this.fwVersion < 3 ? -1 : (this.fwVersion < 5 ? 0 : -1));
        this.versionMap.put(4, version);
        version = this.fwVersion < 0 ? -2 : (this.fwVersion == 0 ? 0 : (this.fwVersion < 5 ? 1 : 2));
        this.versionMap.put(6, version);
        version = this.fwVersion < 0 ? -2 : (this.fwVersion == 0 ? -1 : (this.fwVersion == 1 ? 0 : (this.fwVersion < 5 ? 1 : 2)));
        this.versionMap.put(7, version);
        this.versionMap.put(8, version);
        version = this.fwVersion < 0 ? -2 : (this.fwVersion < 3 ? 0 : 1);
        this.versionMap.put(9, version);
        version = this.fwVersion < 0 ? -2 : (this.fwVersion < 4 ? -1 : 0);
        this.versionMap.put(10, version);
        version = this.fwVersion < 0 ? -2 : (this.fwVersion < 5 ? -1 : 0);
        this.versionMap.put(11, version);
        version = this.fwVersion < 0 ? -2 : (this.fwVersion < 5 ? -1 : 0);
        this.versionMap.put(12, version);
        version = this.fwVersion < 0 ? -2 : (this.fwVersion < 5 ? -1 : 0);
        this.versionMap.put(13, version);
        if (this.fwVersion == -2) {
            throw new REBException("Unknown firmware version");
        }
    }

    private int getPeriod() throws REBException {
        return this.fwVersion == 0 ? 5 : 10;
    }
}

