/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class AsicAdcs
extends BaseSet {
    public static final int REG_TEMP_SLCT = 0x600100;
    public static final int REG_TEMP_READ = 0x600101;
    public static final int REG_TEMP_MUX = 0x600200;
    public static final int TEMP_CABAC_TOP = 0;
    public static final int TEMP_CABAC_BOTTOM = 1;
    public static final int TEMP_ASPIC_TOP = 2;
    public static final int TEMP_ASPIC_BOTTOM = 3;
    public static final int NUM_TEMPS = 4;
    public static final int MUX_T_B_SLOW = 0;
    public static final int MUX_T_FAST_B_SLOW = 1;
    public static final int MUX_T_SLOW_B_FAST = 2;
    public static final int MUX_T_B_FAST = 3;
    public static final int NUM_MUX_SET = 4;
    public static final int REG_FADC_COUNT = 0xC00000;
    public static final int REG_FADC_SAMPS = 0xC00010;
    public static final int NUM_FADC_SAMPS = 16;
    public static final double SADC_SCALE = 2.288818359375E-5;
    public static final double FADC_SCALE = 4.8828125E-4;

    public AsicAdcs() {
    }

    public AsicAdcs(RegClient reg) {
        super(reg);
    }

    public double readSlow(int chan) throws REBException {
        this.getVersion(11);
        if (chan < 0 || chan >= 4) {
            throw new REBException("Invalid slow ADC channel number");
        }
        this.write(0x600100, chan);
        int value = (this.read(0x600101) ^ 0x800000) << 8 >> 14;
        return 2.288818359375E-5 * (double)value;
    }

    public void setMux(int set) throws REBException {
        this.getVersion(11);
        if (set < 0 || set >= 4) {
            throw new REBException("Invalid MUX setting value");
        }
        this.write(0x600200, set);
    }

    public void enableFast() throws REBException {
        this.getVersion(12);
        this.enable(5);
    }

    public void waitFastDone() throws REBException {
        this.getVersion(12);
        this.waitDone(5);
    }

    public void setFastCount(int count) throws REBException {
        this.getVersion(12);
        this.write(0xC00000, count);
    }

    public double[][] getFast(int count) throws REBException {
        this.getVersion(12);
        this.checkFastCount(count);
        double[][] value = new double[2][count];
        double[] sValue = new double[2];
        int j = 0;
        while (j < count) {
            this.readFastSample(j, sValue);
            value[0][j] = sValue[0];
            value[1][j] = sValue[1];
            ++j;
        }
        return value;
    }

    public double[] getFastAvge(int count) throws REBException {
        this.getVersion(12);
        this.checkFastCount(count);
        double[] value = new double[]{0.0, 0.0};
        double[] sValue = new double[2];
        int j = 0;
        while (j < count) {
            this.readFastSample(j, sValue);
            value[0] = value[0] + sValue[0];
            value[1] = value[1] + sValue[1];
            ++j;
        }
        value[0] = value[0] / (double)count;
        value[1] = value[1] / (double)count;
        return value;
    }

    private void checkFastCount(int count) throws REBException {
        if (count < 0 || count >= 16) {
            throw new REBException("Invalid number of fast ADC samples");
        }
    }

    private void readFastSample(int index, double[] value) throws REBException {
        int iValue = this.read(0xC00010 + index);
        value[0] = 4.8828125E-4 * (double)(iValue << 8 >> 20 & 0xFFF);
        value[1] = 4.8828125E-4 * (double)(iValue << 20 >> 20 & 0xFFF);
    }
}

