package org.lsst.ccs.drivers.reb;

/**
 ******************************************************************************
 **
 **  Sensor RTDs reading routines.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class TempRtds extends BaseSet {

   /**
    ***************************************************************************
    **
    **  Public constants
    **
    ***************************************************************************
    */
    public final static int
        REG_RTD_COMMAND = 0x700000,
        REG_RTD_REPLY   = 0x700001,
        NUM_RTD_TEMPS   = 4;
 

   /**
    ***************************************************************************
    **
    **  Constructor.
    **
    ***************************************************************************
    */
    public TempRtds()
    {
        super();
    }


   /**
    ***************************************************************************
    **
    **  Constructor.
    **
    **  @param  reg  The associated register client object
    **
    ***************************************************************************
    */
    public TempRtds(RegClient reg)
    {
        super(reg);
    }


   /**
    ***************************************************************************
    **
    **  Writes a command.
    **
    **  @param  value  The command to write
    **
    **  @exception  REBException 
    **
    ***************************************************************************
    */
    public void writeCommand(int value) throws REBException
    {
        write(REG_RTD_COMMAND, value);
    }


   /**
    ***************************************************************************
    **
    **  Reads a reply.
    **
    **  @return  The read reply
    **
    **  @exception  REBException 
    **
    ***************************************************************************
    */
    public int readReply() throws REBException
    {
        return read(REG_RTD_REPLY);
    }


   /**
    ***************************************************************************
    **
    **  Reads one temperature value.
    **
    **  @param  rtd  The number of the RTD to read
    **
    **  @return  The RTD value (Celsius)
    **
    **  @exception  REBException 
    **
    ***************************************************************************
    */
    public float readRtd(int rtd) throws REBException
    {
        if (rtd < 0 || rtd >= NUM_RTD_TEMPS) {
            throw new REBException("Invalid temperature RTD number");
        }

        return 0F;
    }

}
