/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class Aspic
extends BaseSet {
    public static final int REG_ASPIC = 0xB00000;
    public static final int REG_ASPIC_LOAD = 0xB00000;
    public static final int REG_ASPIC_RESET = 0xB00001;
    public static final int REG_ASPIC_READ = 0xB00011;
    public static final int NUM_STRIPS = 3;
    public static final int SIDE_BOTTOM = 0;
    public static final int SIDE_TOP = 1;
    public static final int NUM_SIDES = 2;
    public static final int RC_MASK = 15;
    public static final int GAIN_POSN = 4;
    public static final int GAIN_INDEX = 0;
    public static final int RC_INDEX = 1;
    public static final int MODE_TM = 1;
    public static final int MODE_AF1 = 2;
    public static final int ADDR_GAIN_RC = 0;
    public static final int ADDR_CLAMP = 1;
    public static final int ADDR_MODES = 2;
    public static final int VALUE_MASK = 255;
    public static final int ADDR_MASK = 3;
    public static final int ADDR_POSN = 16;
    public static final int SIDE_MASK = 3;
    public static final int SIDE_POSN = 24;
    public static final int STRIP_MASK = 7;
    public static final int STRIP_POSN = 26;
    public static final int WRITE_FUNC = 0x800000;

    public Aspic() {
    }

    public Aspic(RegClient reg) {
        super(reg);
    }

    public void writeGainRc(int strips, int sides, int gain, int rc) throws REBException {
        this.writeParam(strips, sides, 0, rc & 0xF | gain << 4);
    }

    public void writeClamp(int strips, int sides, int clamp) throws REBException {
        this.writeParam(strips, sides, 1, clamp);
    }

    public void writeModes(int strips, int sides, int modes) throws REBException {
        this.writeParam(strips, sides, 2, modes);
    }

    public int[][] readGainRc(int strips, int side) throws REBException {
        int[] value = this.readParam(strips, side, 0);
        return new int[][]{{value[0] >> 4, value[0] & 0xF}, {value[1] >> 4, value[1] & 0xF}, {value[2] >> 4, value[2] & 0xF}};
    }

    public int[] readClamp(int strips, int side) throws REBException {
        return this.readParam(strips, side, 1);
    }

    public int[] readModes(int strips, int side) throws REBException {
        return this.readParam(strips, side, 2);
    }

    public void reset(int strip) throws REBException {
        this.checkVersion(4, -3);
        this.write(0xB00001, strip);
    }

    public void writeParam(int strips, int sides, int addr, int value) throws REBException {
        this.checkVersion(4, -3);
        this.write(0xB00000, value & 0xFF | (sides & 3) << 24 | (strips & 7) << 26 | 0x800000);
    }

    public int[] readParam(int strips, int side, int addr) throws REBException {
        this.checkVersion(4, -3);
        this.write(0xB00000, (1 << side & 3) << 24 | (strips & 7) << 26);
        int[] value = new int[3];
        int j = 0;
        while (j < value.length) {
            value[j] = (strips & 1) == 0 ? 0 : this.read(0xB00011 + j);
            ++j;
            strips >>= 1;
        }
        return value;
    }
}

