/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.io.PrintStream;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class TestSpeed {
    private static final PrintStream out = System.out;

    public static void main(String[] args) throws REBException {
        if (args.length < 3) {
            out.println("Parameters are: rebid regnum nreg count");
            System.exit(0);
        }
        int[] iArgs = new int[4];
        int j = 0;
        while (j < iArgs.length) {
            try {
                iArgs[j] = Integer.decode(args[j]);
            }
            catch (NumberFormatException numberFormatException) {
                out.println("Invalid integer for parameter " + j);
                System.exit(0);
            }
            ++j;
        }
        new TestSpeed().run(iArgs[0], iArgs[1], iArgs[2], iArgs[3]);
        System.exit(0);
    }

    public void run(int rebid, int regnum, int nreg, int count) throws REBException {
        RegClient reg = new RegClient();
        reg.open(rebid);
        long start = System.currentTimeMillis();
        int nread = 0;
        int[] data = new int[nreg];
        int j = 0;
        while (j < count) {
            reg.read(regnum, data);
            nread += nreg;
            ++j;
        }
        long time = System.currentTimeMillis() - start;
        int rate = time == 0L ? 0 : (int)((long)(1000 * nread) / time);
        out.format("Performed %s reads in %s msecs, rate = %s reads/sec\n", nread, time, rate);
    }
}

