/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class Cabac
extends BaseSet {
    public static final int REG_CABAC = 0x500000;
    public static final int CABAC_OFF_LOAD = 0;
    public static final int CABAC_OFF_FETCH = 1;
    public static final int CABAC_OFF_RESET = 2;
    public static final int CABAC_OFF_LOAD_1 = 5;
    public static final int CABAC_OFF_RESET_1 = 6;
    public static final int CABAC_OFF_FETCH_1 = 7;
    public static final int CABAC_OFF_BOTTOM = 16;
    public static final int CABAC_OFF_TOP = 32;
    public static final int CABAC_OFF_WRITE = 0;
    public static final int CABAC_OFF_READ = 256;
    public static final int NUM_CABAC_REGS = 5;
    public static final int CABAC_ID_BOTTOM = 0;
    public static final int CABAC_ID_TOP = 1;
    public static final int NUM_CABAC_PAIRS = 3;
    public static final int NUM_CABACS = 6;
    public static final int CABAC_FLD_OD_EXP0 = 0;
    public static final int CABAC_FLD_OD_EXP1 = 1;
    public static final int CABAC_FLD_OD_RDO0 = 2;
    public static final int CABAC_FLD_OD_RDO1 = 3;
    public static final int CABAC_FLD_PCLK0 = 4;
    public static final int CABAC_FLD_PCLK1 = 5;
    public static final int CABAC_FLD_PCLK2 = 6;
    public static final int CABAC_FLD_PCLK3 = 7;
    public static final int CABAC_FLD_SCLK0 = 8;
    public static final int CABAC_FLD_SCLK1 = 9;
    public static final int CABAC_FLD_SCLK2 = 10;
    public static final int CABAC_FLD_RG = 11;
    public static final int CABAC_FLD_GD = 12;
    public static final int CABAC_FLD_OG = 13;
    public static final int CABAC_FLD_RD = 14;
    public static final int CABAC_FLD_SPH = 15;
    public static final int CABAC_FLD_SPL = 16;
    public static final int CABAC_FLD_MUX0 = 17;
    public static final int CABAC_FLD_MUX1 = 18;
    public static final int CABAC_FLD_PULSE = 19;
    public static final int CABAC_FLD_MUXE = 20;
    public static final int NUM_CABAC_FLDS = 21;
    public static final int[] FIELD_LENGTHS = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 1, 1};
    public static final int[] FIELD_STARTS;
    public static final int[] FIELD_STARTS_1;

    static {
        int[] nArray = new int[21];
        nArray[1] = 8;
        nArray[2] = 16;
        nArray[3] = 24;
        nArray[4] = 32;
        nArray[5] = 40;
        nArray[6] = 48;
        nArray[7] = 56;
        nArray[8] = 64;
        nArray[9] = 72;
        nArray[10] = 80;
        nArray[11] = 88;
        nArray[12] = 96;
        nArray[13] = 104;
        nArray[14] = 112;
        nArray[15] = 120;
        nArray[16] = 128;
        nArray[17] = 136;
        nArray[18] = 140;
        nArray[19] = 144;
        nArray[20] = 145;
        FIELD_STARTS = nArray;
        int[] nArray2 = new int[21];
        nArray2[0] = 2;
        nArray2[1] = 10;
        nArray2[2] = 18;
        nArray2[3] = 26;
        nArray2[4] = 34;
        nArray2[5] = 42;
        nArray2[6] = 50;
        nArray2[7] = 58;
        nArray2[8] = 66;
        nArray2[9] = 74;
        nArray2[10] = 82;
        nArray2[11] = 90;
        nArray2[12] = 98;
        nArray2[13] = 106;
        nArray2[14] = 114;
        nArray2[15] = 122;
        nArray2[16] = 130;
        nArray2[17] = 138;
        nArray2[18] = 142;
        nArray2[20] = 1;
        FIELD_STARTS_1 = nArray2;
    }

    public Cabac() {
    }

    public Cabac(RegClient reg) {
        super(reg);
    }

    public void load(int pair) throws REBException {
        this.checkVersion(2, -3);
        this.checkPair(pair);
        this.write(0x500000, pair);
    }

    public void reset(int pair) throws REBException {
        this.checkVersion(2, -3);
        this.checkPair(pair);
        this.write(0x500002, pair);
    }

    public void fetch(int pair) throws REBException {
        this.checkVersion(2, -3);
        this.checkPair(pair);
        this.write(0x500001, pair);
    }

    public void set(int cabac, int field, int value) throws REBException {
        this.checkVersion(2, -3);
        int base = this.getBase(cabac);
        this.checkField(field);
        int beg = FIELD_STARTS[field];
        int end = beg + FIELD_LENGTHS[field];
        int mask = (1 << end - beg) - 1;
        int regBeg = beg >> 5;
        int regEnd = end - 1 >> 5;
        int bitEnd = 32 - end & 0x1F;
        if (regEnd == regBeg) {
            this.updateReg(base, regBeg, mask << bitEnd, value << bitEnd);
        } else {
            this.updateReg(base, regBeg, mask >> 32 - bitEnd, value >> 32 - bitEnd);
            this.updateReg(base, regEnd, mask << bitEnd, value << bitEnd);
        }
    }

    public void set(int cabac, int[] value) throws REBException {
        this.checkVersion(2, -3);
        int base = this.getBase(cabac) + 0;
        int[] regs = new int[5];
        int j = 0;
        while (j < regs.length) {
            regs[j] = 0;
            ++j;
        }
        j = 0;
        while (j < 21) {
            int beg = FIELD_STARTS[j];
            int end = beg + FIELD_LENGTHS[j];
            int val = value[j] & (1 << end - beg) - 1;
            int regBeg = beg >> 5;
            int regEnd = end - 1 >> 5;
            int bitEnd = 32 - end & 0x1F;
            if (regEnd == regBeg) {
                int n = regBeg;
                regs[n] = regs[n] | val << bitEnd;
            } else {
                int n = regBeg;
                regs[n] = regs[n] | val >> 32 - bitEnd;
                int n2 = regEnd;
                regs[n2] = regs[n2] | val << bitEnd;
            }
            ++j;
        }
        this.write(base, regs);
    }

    public void set(int cabac, int first, int count, int[] value) throws REBException {
        this.checkVersion(2, -3);
        int base = this.getBase(cabac);
        this.checkField(first, count);
        int[] regs = new int[5];
        int[] masks = new int[5];
        int j = 0;
        while (j < regs.length) {
            regs[j] = 0;
            masks[j] = 0;
            ++j;
        }
        j = 0;
        while (j < count) {
            int beg = FIELD_STARTS[first + j];
            int end = beg + FIELD_LENGTHS[first + j];
            int mask = (1 << end - beg) - 1;
            int val = value[j] & mask;
            int regBeg = beg >> 5;
            int regEnd = end - 1 >> 5;
            int bitEnd = 32 - end & 0x1F;
            if (regEnd == regBeg) {
                int n = regBeg;
                regs[n] = regs[n] | val << bitEnd;
                int n2 = regBeg;
                masks[n2] = masks[n2] | mask << bitEnd;
            } else {
                int n = regBeg;
                regs[n] = regs[n] | val >> 32 - bitEnd;
                int n3 = regEnd;
                regs[n3] = regs[n3] | val << bitEnd;
                int n4 = regBeg;
                masks[n4] = masks[n4] | mask >> 32 - bitEnd;
                int n5 = regEnd;
                masks[n5] = masks[n5] | mask << bitEnd;
            }
            ++j;
        }
        j = 0;
        while (j < regs.length) {
            if (masks[j] != 0) {
                if (masks[j] == -1) {
                    this.write(base + 0 + j, regs[j]);
                } else {
                    this.updateReg(base, j, masks[j], regs[j]);
                }
            }
            ++j;
        }
    }

    public int get(int cabac, int field) throws REBException {
        this.checkVersion(2, -3);
        int base = this.getBase(cabac) + 256;
        this.checkField(field);
        int beg = FIELD_STARTS[field];
        int end = beg + FIELD_LENGTHS[field];
        int mask = (1 << end - beg) - 1;
        int regBeg = beg >> 5;
        int regEnd = end - 1 >> 5;
        int bitEnd = 32 - end & 0x1F;
        if (regEnd == regBeg) {
            return this.read(base + regBeg) >> bitEnd & mask;
        }
        return (this.read(base + regBeg) << 32 - bitEnd | this.read(base + regEnd) >>> bitEnd) & mask;
    }

    public int[] get(int cabac) throws REBException {
        return this.get(cabac, 0, 21);
    }

    public int[] get(int cabac, int first, int count) throws REBException {
        this.checkVersion(2, -3);
        int base = this.getBase(cabac) + 256;
        this.checkField(first, count);
        int[] regs = new int[5];
        int[] value = new int[count];
        this.read(base, regs);
        int j = 0;
        while (j < count) {
            int beg = FIELD_STARTS[first + j];
            int end = beg + FIELD_LENGTHS[first + j];
            int mask = (1 << end - beg) - 1;
            int regBeg = beg >> 5;
            int regEnd = end - 1 >> 5;
            int bitEnd = 32 - end & 0x1F;
            value[j] = regEnd == regBeg ? regs[regBeg] >> bitEnd : (regs[regBeg] << 32 - bitEnd | regs[regEnd] >>> bitEnd) & mask;
            ++j;
        }
        return value;
    }

    public int[] readRaw(int cabac) throws REBException {
        this.checkVersion(2, -3);
        int base = this.getBase(cabac) + 256;
        int[] regs = new int[5];
        this.read(base, regs);
        return regs;
    }

    private void checkPair(int pair) throws REBException {
        if (pair < 0 || pair >= 3) {
            throw new REBException("Invalid CABAC pair number");
        }
    }

    private int getBase(int cabac) throws REBException {
        if (cabac != 0 && cabac != 1) {
            throw new REBException("Invalid CABAC ID");
        }
        return 0x500000 + (cabac == 0 ? 16 : 32);
    }

    private void checkField(int field) throws REBException {
        if (field < 0 || field >= 21) {
            throw new REBException("Invalid CABAC field number");
        }
    }

    private void checkField(int first, int count) throws REBException {
        if (first < 0 || count < 0 || first + count > 21) {
            throw new REBException("Invalid CABAC field number");
        }
    }

    private void updateReg(int base, int reg, int mask, int value) throws REBException {
        this.write(base + 0 + reg, this.read(base + 256 + reg) & ~mask | value & mask);
    }
}

