package org.lsst.ccs.drivers.reb;

/**
 ***************************************************************************
 **
 **  REB status block.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class Status {

   /**
    ***************************************************************************
    **
    **  Package fields.
    **
    ***************************************************************************
    */
    int version;
    int linkStat;
    int cerrCount;
    int ldwnCount;
    int lerrCount;
    int buffStat;
    int[] rxCount = new int[4];
    int[] txCount = new int[4];
    int sentCount;
    int discCount;
    int truncCount;
    int format;


   /**
    ***************************************************************************
    **
    **  Gets the version.
    **
    ***************************************************************************
    */
    public int getVersion()
    {
        return version;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP link status.
    **
    ***************************************************************************
    */
    public int getLinkStatus()
    {
        return linkStat;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP cell error count.
    **
    ***************************************************************************
    */
    public int getCellErrorCount()
    {
        return cerrCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP link down count.
    **
    ***************************************************************************
    */
    public int getLinkDownCount()
    {
        return ldwnCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP link error count.
    **
    ***************************************************************************
    */
    public int getLinkErrorCount()
    {
        return lerrCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP VC buffer status.
    **
    ***************************************************************************
    */
    public int getVcBufferStatus()
    {
        return buffStat;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP VC receive counters.
    **
    ***************************************************************************
    */
    public int[] getVcRxCounts()
    {
        return rxCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP VC transmit counters.
    **
    ***************************************************************************
    */
    public int[] getVcTxCounts()
    {
        return txCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the sent images counter.
    **
    ***************************************************************************
    */
    public int getSentCount()
    {
        return sentCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the discarded images counter.
    **
    ***************************************************************************
    */
    public int getDiscCount()
    {
        return discCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the truncated images counter.
    **
    ***************************************************************************
    */
    public int getTruncCount()
    {
        return truncCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the image data format.
    **
    ***************************************************************************
    */
    public int getFormat()
    {
        return format;
    }

}
