/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.PowerAdcs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.SequencerUtils;
import org.lsst.ccs.drivers.reb.Status;
import org.lsst.ccs.drivers.reb.StatusSet;
import org.lsst.ccs.drivers.reb.TempAdcs;

public class TestReg {
    private final BaseSet bset = new BaseSet();
    private final SequencerUtils seq = new SequencerUtils(this.bset);
    private final StatusSet sset = new StatusSet(this.bset);
    private final TempAdcs tmp = new TempAdcs(this.bset);
    private final PowerAdcs pwr = new PowerAdcs(this.bset);
    private final BoardDacs dac = new BoardDacs(this.bset);
    private int rebId = -1;
    private boolean contActive;
    private BlockingQueue<Integer> consQueue = new ArrayBlockingQueue<Integer>(1);

    public TestReg() {
        ConsThread cons = new ConsThread();
        cons.setDaemon(true);
        cons.start();
    }

    @Command(name="connect", description="Connect to a REB")
    public void connect(@Argument(name="id", description="REB ID") int id) throws REBException {
        this.rebId = id;
        this.bset.open(this.rebId);
    }

    @Command(name="connect", description="Connect to a REB")
    public void connect(@Argument(name="id", description="REB ID") int id, @Argument(name="ifcname", description="Network interface name") String ifcName) throws REBException {
        this.rebId = id;
        this.bset.open(this.rebId, ifcName);
    }

    @Command(name="disconnect", description="Disconnect from a REB")
    public void disconnect() throws REBException {
        this.bset.close();
        this.rebId = -1;
    }

    @Command(name="show", description="Show connection parameters")
    public String show() {
        boolean connected = false;
        int version = -1;
        try {
            this.bset.checkOpen();
            connected = true;
        }
        catch (REBException rEBException) {}
        try {
            version = this.bset.getVersion();
        }
        catch (REBException rEBException) {}
        return "Connection parameters:\n  Connected  = " + connected + "\n  REB id     = " + this.rebId + "\n  Version    = " + version;
    }

    @Command(name="read", description="Show one register")
    public String read(@Argument(name="address", description="Register address to read") int address) throws REBException {
        return String.format("%06x: %08x", address, this.bset.read(address));
    }

    @Command(name="read", description="Show one or more registers")
    public String read(@Argument(name="address", description="First register address to read") int address, @Argument(name="count", description="Number of registers to read") int count) throws REBException {
        int[] values = new int[count];
        this.bset.read(address, values);
        StringBuilder result = new StringBuilder(9 * (count + (count + 3) / 4));
        int j = 0;
        while (j < count) {
            if ((j & 3) == 0) {
                if (j != 0) {
                    result.append("\n");
                }
                result.append(String.format("%06x:", address));
            }
            result.append(String.format(" %08x", values[j]));
            ++j;
            ++address;
        }
        return result.toString();
    }

    @Command(name="write", description="Write a register")
    public void write(@Argument(name="address", description="Register address to write") int address, @Argument(name="value", description="Value to write") int value) throws REBException {
        this.bset.write(address, value);
    }

    @Command(name="update", description="Update a register")
    public void update(@Argument(name="address", description="Address of register to update") int address, @Argument(name="mask", description="Mask of bits to update") int mask, @Argument(name="value", description="New value to write") int value) throws REBException {
        this.bset.update(address, mask, value);
    }

    @Command(name="readlong", description="Show a pair of registers")
    public String readLong(@Argument(name="address", description="Address of first register to read") int address) throws REBException {
        return String.format("%06x: %016x\n", address, this.bset.readLong(address));
    }

    @Command(name="writelong", description="Write a pair of registers")
    public void writeLong(@Argument(name="address", description="Address of first register to write") int address, @Argument(name="value", description="Value to write") long value) throws REBException {
        this.bset.writeLong(address, value);
    }

    @Command(name="enable", description="Enable a register set")
    public void enable(@Argument(name="regset", description="Register set name") RsetId regset) throws REBException {
        this.bset.enable(regset.getValue());
    }

    @Command(name="disable", description="Disable a register set")
    public void disable(@Argument(name="regset", description="Register set name") RsetId regset) throws REBException {
        this.bset.disable(regset.getValue());
    }

    @Command(name="trigtime", description="Show a trigger time")
    public String trigtime(@Argument(name="regset", description="Register set name") RsetId regset) throws REBException {
        long time = this.bset.getTriggerTime(regset.getValue());
        GregorianCalendar tm = new GregorianCalendar();
        tm.setTimeInMillis(time);
        return String.format("Time = %tY-%<tm-%<td %<tH:%<tM:%<tS.%<tL", tm);
    }

    @Command(name="time", description="Show the time")
    public String time() throws REBException {
        long time = this.bset.getTime();
        GregorianCalendar tm = new GregorianCalendar();
        tm.setTimeInMillis(time);
        return String.format("Time = %tY-%<tm-%<td %<tH:%<tM:%<tS.%<tL", tm);
    }

    @Command(name="time", description="Set the time")
    public String setTime(@Argument(name="time", description="The time to set") String time) throws REBException {
        String result = "\u001b[A";
        if (time.equals(".")) {
            this.bset.setTime();
        } else {
            SimpleDateFormat fmt = new SimpleDateFormat();
            fmt.setLenient(true);
            fmt.applyPattern("y-M-d H:m:s");
            ParsePosition pos = new ParsePosition(0);
            Date date = fmt.parse(time, pos);
            if (date == null) {
                result = "Expected format is yyyy-mm-dd hh:mm:ss";
            } else {
                this.bset.setTime(date.getTime());
            }
        }
        return result;
    }

    @Command(name="timebase", description="Show the time base")
    public String timebase() throws REBException {
        return "Value = " + this.bset.getTimeRaw();
    }

    @Command(name="timebase", description="Set the time base")
    public void timebase(@Argument(name="time", description="The value to set") long time) throws REBException {
        this.bset.setTimeRaw(time);
    }

    @Command(name="loadtest", description="Load sequencer with test program")
    public void loadTest(@Argument(name="totTime", description="The total time per cycle") int totTime, @Argument(name="ncycle", description="The number of cycles") int ncycle) throws REBException {
        this.loadTest(totTime, ncycle, 10);
    }

    @Command(name="loadtest", description="Load sequencer with test program")
    public void loadTest(@Argument(name="totTime", description="The total time per cycle") int totTime, @Argument(name="ncycle", description="The number of cycles") int ncycle, @Argument(name="ontime", description="The time the ADC is on per cycle") int onTime) throws REBException {
        this.seq.writeLines(0, new int[1]);
        int[] nArray = new int[2];
        nArray[0] = 4096;
        this.seq.writeLines(1, nArray);
        int[] nArray2 = new int[3];
        nArray2[0] = onTime;
        nArray2[1] = totTime - onTime;
        this.seq.writeTimes(1, nArray2);
        if (this.seq.getVersion() == 0) {
            this.seq.writeStack(new int[]{0x10000000 | ncycle & 0x3FFFFFF});
            this.seq.writeDataSource(0);
        } else {
            this.seq.writeProgExec(0, 1, ncycle);
            this.seq.writeProgEnd(1);
            this.seq.writeDataSource(1);
        }
        this.seq.writeSliceCount(ncycle);
    }

    @Command(name="loadcommand", description="Load command into sequencer")
    public void loadCommand(@Argument(name="command", description="The command to load") String command) throws REBException {
        this.seq.loadCommand(command);
    }

    @Command(name="loadfile", description="Load command file into sequencer")
    public String loadFile(@Argument(name="filename", description="The name of the file to load") String fileName) throws REBException, IOException {
        int nSlice = this.seq.loadFile(fileName);
        return "Slice count = " + nSlice;
    }

    @Command(name="slice", description="Show the slice count")
    public String sliceCount() throws REBException {
        return "Slice count = " + this.seq.readSliceCount();
    }

    @Command(name="slice", description="Set the slice count")
    public void sliceCount(@Argument(name="count", description="The value to set") int count) throws REBException {
        this.seq.writeSliceCount(count);
    }

    @Command(name="source", description="Show the data source")
    public String dataSource() throws REBException {
        return "Data source = " + this.seq.readDataSource();
    }

    @Command(name="source", description="Set the data source")
    public void dataSource(@Argument(name="value", description="The value to set") int value) throws REBException {
        this.seq.writeDataSource(value);
    }

    @Command(name="stripe", description="Show the stripe selection")
    public String stripeSelect() throws REBException {
        return "Stripe selection = " + this.seq.readStripeSelect();
    }

    @Command(name="stripe", description="Set the stripe selection")
    public void stripeSelect(@Argument(name="value", description="The value to set") int value) throws REBException {
        this.seq.writeStripeSelect(value);
    }

    @Command(name="status", description="Show status block contents")
    public String showStatus() throws REBException {
        Status status = this.sset.readStatus();
        StringBuilder result = new StringBuilder();
        result.append("Status Block:\n");
        result.append(String.format("  Version               = %08x  ", status.getVersion()));
        result.append(String.format("  Link Status           = %08x\n", status.getLinkStatus()));
        result.append(String.format("  Cell error count      = %-8s  ", status.getCellErrorCount()));
        result.append(String.format("  Link down count       = %s\n", status.getLinkDownCount()));
        result.append(String.format("  Link error count      = %-8s  ", status.getLinkErrorCount()));
        result.append(String.format("  VC buffer status      = %08x\n", status.getVcBufferStatus()));
        int[] counts = status.getVcRxCounts();
        result.append("  VC rcve counts        =");
        int j = 0;
        while (j < counts.length) {
            result.append(String.format(" %s", counts[j]));
            ++j;
        }
        result.append("\n");
        counts = status.getVcTxCounts();
        result.append("  VC xmit counts        =");
        j = 0;
        while (j < counts.length) {
            result.append(String.format(" %s", counts[j]));
            ++j;
        }
        result.append("\n");
        result.append(String.format("  Sent image count      = %-8s  ", status.getSentCount()));
        result.append(String.format("  Discarded image count = %s\n", status.getDiscCount()));
        result.append(String.format("  Truncated image count = %-8s  ", status.getTruncCount()));
        result.append(String.format("  Image format          = %s", status.getFormat()));
        return result.toString();
    }

    @Command(name="temperature", description="Show all board temperatures")
    public String temperature() throws REBException {
        return TestReg.formatAdcs(this.tmp.readAdcs(), 0);
    }

    @Command(name="temperature", description="Show a board temperature")
    public String temperature(@Argument(name="first", description="The temperature to show") int first) throws REBException {
        float[] values = new float[]{this.tmp.readAdc(first)};
        return TestReg.formatAdcs(values, first);
    }

    @Command(name="temperature", description="Show board temperatures")
    public String temperature(@Argument(name="first", description="The first temperature to show") int first, @Argument(name="count", description="The number of temperatures to show") int count) throws REBException {
        return TestReg.formatAdcs(this.tmp.readAdcs(first, count), first);
    }

    @Command(name="power", description="Show all board power values")
    public String power() throws REBException {
        return TestReg.formatAdcs(this.pwr.readAdcs(), 0);
    }

    @Command(name="power", description="Show a board power value")
    public String power(@Argument(name="first", description="The power value to show") int first) throws REBException {
        float[] values = new float[]{this.pwr.readAdc(first)};
        return TestReg.formatAdcs(values, first);
    }

    @Command(name="power", description="Show board power values")
    public String power(@Argument(name="first", description="The first power value to show") int first, @Argument(name="count", description="The number of power values to show") int count) throws REBException {
        return TestReg.formatAdcs(this.pwr.readAdcs(first, count), first);
    }

    @Command(name="dac", description="Set a DAC value")
    public void dac(@Argument(name="number", description="The DAC number (0 or 1)") int number, @Argument(name="chan", description="The channel number (0 - 7)") int chan, @Argument(name="value", description="The value to set") int value) throws REBException {
        this.dac.set(number, chan, value);
    }

    @Command(name="contread", description="Continuously read registers")
    public String contRead(@Argument(name="address", description="The first register to read") int address, @Argument(name="count", description="The number of registers to read") int count) throws REBException {
        int[] values = new int[count];
        int nRead = 0;
        long startTime = System.currentTimeMillis();
        System.out.println("Press any key to terminate...");
        this.contActive = true;
        this.consQueue.offer(0);
        try {
            while (this.contActive) {
                this.bset.read(address, values);
                nRead += count;
            }
        }
        catch (Throwable throwable) {}
        double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
        return String.format("Read rate = %.4g Hz", rate);
    }

    @Command(name="conttemp", description="Continuously read temperatures")
    public String contTemp() throws REBException {
        int nRead = 0;
        long startTime = System.currentTimeMillis();
        System.out.println("Press any key to terminate...");
        this.contActive = true;
        this.consQueue.offer(0);
        try {
            while (this.contActive) {
                this.tmp.readAdcs();
                ++nRead;
            }
        }
        catch (Throwable throwable) {}
        double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
        return String.format("Read rate = %.4g Hz", rate);
    }

    @Command(name="contpower", description="Continuously read power values")
    public String contPower() throws REBException {
        int nRead = 0;
        long startTime = System.currentTimeMillis();
        System.out.println("Press any key to terminate...");
        this.contActive = true;
        this.consQueue.offer(0);
        try {
            while (this.contActive) {
                this.pwr.readAdcs();
                ++nRead;
            }
        }
        catch (Throwable throwable) {}
        double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
        return String.format("Read rate = %.4g Hz", rate);
    }

    private static String formatAdcs(float[] values, int index) {
        StringBuilder result = new StringBuilder();
        int j = 0;
        while (j < values.length) {
            if ((j & 3) == 0) {
                result.append(j == 0 ? "ADCs:" : "\n     ");
            }
            result.append(String.format("  %2s: %6g", j + index, Float.valueOf(values[j])));
            ++j;
        }
        return result.toString();
    }

    private static void take(BlockingQueue queue) {
        while (true) {
            try {
                queue.take();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static void awaitTerminal() {
        while (true) {
            try {
                while (true) {
                    if (System.in.available() > 0) {
                        return;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private static void clearTerminal() {
        try {
            while (System.in.available() > 0) {
                System.in.read();
            }
        }
        catch (IOException iOException) {}
    }

    class ConsThread
    extends Thread {
        ConsThread() {
        }

        @Override
        public void run() {
            block0: while (true) {
                TestReg.take(TestReg.this.consQueue);
                while (true) {
                    if (!TestReg.this.contActive) continue block0;
                    TestReg.awaitTerminal();
                    if (TestReg.this.contActive) {
                        TestReg.clearTerminal();
                    }
                    TestReg.this.contActive = false;
                }
                break;
            }
        }
    }

    public static enum RsetId {
        STATUS(0),
        TIMEBASE(1),
        SEQUENCER(2),
        POWERADCS(3),
        TEMPADCS(4);

        int value;

        private RsetId(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

