/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class Sequencer
extends BaseSet {
    public static final int REG_SEQ_LINES = 0x100000;
    public static final int REG_SEQ_TIMES = 0x200000;
    public static final int REG_SEQ_STACK = 0x300000;
    public static final int REG_SEQ_PROGRAM = 0x300000;
    public static final int REG_SEQ_STEP = 0x310000;
    public static final int REG_SEQ_STOP = 0x320000;
    public static final int REG_SEQ_SSIZE = 0x400000;
    public static final int REG_SEQ_NSLICE = 0x400005;
    public static final int REG_SEQ_SOURCE = 0x400006;
    public static final int REG_SEQ_STRIPE = 0x400007;
    public static final int REG_SEQ_BEB = 0x400007;
    public static final int REG_SEQ_STEP_0 = 0x500000;
    public static final int REG_SEQ_STOP_0 = 0x600000;
    public static final int SEQ_MAX_FUNC_0 = 4;
    public static final int SEQ_MAX_FUNC = 16;
    public static final int SEQ_MAX_SLICE = 16;
    public static final int SEQ_MAX_PROGRAM = 1024;
    public static final int SEQ_MAX_STACK = 4096;
    public static final int SEQ_SRC_FPGA_PTN = 0;
    public static final int SEQ_SRC_BEB_PTN = 7147;
    public static final int SEQ_SRC_BEB_ADC = 3051;
    public static final int SEQ_SRC_ADC = 0;
    public static final int SEQ_SRC_PATTERN = 1;
    public static final int SEQ_OPC_EXECUTE = 1;
    public static final int SEQ_OPC_JUMP = 2;
    public static final int SEQ_OPC_END_SUBR = 3;
    public static final int SEQ_OPC_END_PROG = 4;
    public static final int SEQ_PRG_V_OPCODE = 28;
    public static final int SEQ_PRG_V_FUNC = 24;
    public static final int SEQ_PRG_M_FUNC = 15;
    public static final int SEQ_PRG_V_LOOP = 23;
    public static final int SEQ_PRG_M_EXCCNT = 0x7FFFFF;
    public static final int SEQ_PRG_V_SUBADD = 18;
    public static final int SEQ_PRG_M_SUBADD = 1023;
    public static final int SEQ_PRG_M_SUBCNT = 131071;
    public static final int SEQ_STK_V_FUNC = 28;
    public static final int SEQ_STK_M_FUNC = 3;
    public static final int SEQ_STK_V_LOOP = 27;
    public static final int SEQ_STK_M_COUNT = 0x7FFFFFF;
    public static final int MAX_SUBR_LEVEL = 16;
    protected int[][] lines = new int[16][16];
    protected int[][] times = new int[16][16];
    protected int[] prog = new int[1024];
    protected int[] stack = new int[4096];
    protected int stackSize;

    public Sequencer(RegClient reg) {
        super(reg);
    }

    public Sequencer() {
    }

    @Override
    public void enable() throws REBException {
        this.enable(2);
    }

    @Override
    public void disable() throws REBException {
        this.disable(2);
    }

    public long getTriggerTime() throws REBException {
        return this.getTriggerTime(2);
    }

    public void writeLines(int func, int slice, int value) throws REBException {
        this.checkFunc(func);
        this.checkSlice(slice);
        this.write(0x100000 | func << 4 | slice, value);
        this.lines[func][slice] = value;
    }

    public void writeLines(int func, int[] values) throws REBException {
        this.writeLines(func, values, 0, values.length);
    }

    public void writeLines(int func, int[] values, int offset, int count) throws REBException {
        this.checkFunc(func);
        this.checkSlice(count - 1);
        this.write(0x100000 | func << 4, values, offset, count);
        System.arraycopy(values, offset, this.lines[func], 0, count);
    }

    public void writeTimes(int func, int slice, int value) throws REBException {
        this.checkFunc(func);
        this.checkSlice(slice);
        this.write(0x200000 | func << 4 | slice, value);
        this.times[func][slice] = value;
    }

    public void writeTimes(int func, int[] values) throws REBException {
        this.writeTimes(func, values, 0, values.length);
    }

    public void writeTimes(int func, int[] values, int offset, int count) throws REBException {
        this.checkFunc(func);
        this.checkSlice(count - 1);
        this.write(0x200000 | func << 4, values, offset, count);
        System.arraycopy(values, offset, this.times[func], 0, count);
    }

    public void writeStack(int addr, int value) throws REBException {
        this.checkVersion(0);
        this.checkStackAddr(addr);
        this.write(0x300000 + addr, value);
        this.stack[addr] = value;
    }

    public void writeStack(int addr, int[] values) throws REBException {
        this.writeStack(addr, values, 0, values.length);
    }

    public void writeStack(int addr, int[] values, int offset, int count) throws REBException {
        this.checkVersion(0);
        this.checkStackAddr(addr, count);
        this.write(0x300000 + addr, values, offset, count);
        System.arraycopy(values, offset, this.stack, addr, count);
    }

    public void writeStack(int[] values) throws REBException {
        this.writeStack(values, 0, values.length);
    }

    public void writeStack(int[] values, int offset, int count) throws REBException {
        this.checkVersion(0);
        this.checkStackAddr(0, count);
        this.write(0x300000, values, offset, count);
        this.write(0x400000, count);
        System.arraycopy(values, offset, this.stack, 0, count);
        this.stackSize = count;
    }

    public void writeStackSize(int value) throws REBException {
        this.checkVersion(0);
        this.write(0x400000, value);
        this.stackSize = value;
    }

    public void writeProgram(int addr, int value) throws REBException {
        this.checkNotVersion(0);
        this.checkProgAddr(addr);
        this.write(0x300000 + addr, value);
        this.prog[addr] = value;
    }

    public void writeProgram(int addr, int[] values) throws REBException {
        this.writeProgram(addr, values, 0, values.length);
    }

    public void writeProgram(int addr, int[] values, int offset, int count) throws REBException {
        this.checkNotVersion(0);
        this.checkProgAddr(addr, count);
        this.write(0x300000 + addr, values, offset, count);
        System.arraycopy(values, offset, this.prog, addr, count);
    }

    public void writeProgExec(int addr, int func, int count) throws REBException {
        this.checkFunc(func);
        int value = count & 0x7FFFFF;
        if (count != -1 && count != value) {
            throw new REBException("Invalid repetition count");
        }
        this.writeProgram(addr, value |= 0x10000000 | func << 24 | (count == -1 ? 0x800000 : 0));
    }

    public void writeProgJump(int addr, int subaddr, int count) throws REBException {
        this.checkProgAddr(subaddr);
        int value = count & 0x1FFFF;
        if (count != value) {
            throw new REBException("Invalid repetition count");
        }
        this.writeProgram(addr, value |= 0x20000000 | subaddr << 18);
    }

    public void writeProgEndSubr(int addr) throws REBException {
        this.writeProgram(addr, 0x30000000);
    }

    public void writeProgEnd(int addr) throws REBException {
        this.writeProgram(addr, 0x40000000);
    }

    public void writeSliceCount(int value) throws REBException {
        this.write(0x400005, value);
    }

    public int readSliceCount() throws REBException {
        return this.read(0x400005);
    }

    public void writeDataSource(int value) throws REBException {
        this.write(0x400006, value);
    }

    public int readDataSource() throws REBException {
        return this.read(0x400006);
    }

    public void writeStripeSelect(int value) throws REBException {
        this.checkVersion(3, -3);
        this.write(0x400007, value);
    }

    public int readStripeSelect() throws REBException {
        this.checkVersion(3, -3);
        return this.read(0x400007);
    }

    public void writeBebSelect(int value) throws REBException {
        this.checkVersion(0);
        this.write(0x400007, value);
    }

    public void sendStep() throws REBException {
        int stepAddr = this.getVersion() == 0 ? 0x500000 : 0x310000;
        this.write(stepAddr, 0);
    }

    public void sendStop() throws REBException {
        int stopAddr = this.getVersion() == 0 ? 0x600000 : 0x320000;
        this.write(stopAddr, 0);
    }

    public void clearCache() throws REBException {
        int j = 0;
        while (j < this.lines.length) {
            int k = 0;
            while (k < this.lines[j].length) {
                this.lines[j][k] = 0;
                this.times[j][k] = 0;
                ++k;
            }
            ++j;
        }
        if (this.getVersion() == 0) {
            j = 0;
            while (j < this.stack.length) {
                this.stack[j] = 0;
                ++j;
            }
            this.stackSize = 0;
        } else {
            j = 0;
            while (j < this.prog.length) {
                this.prog[j] = 0;
                ++j;
            }
        }
    }

    public int getCacheSliceCount() throws REBException {
        int maxFunc = this.getVersion() == 0 ? 4 : 16;
        int[] funcSlice = new int[maxFunc];
        funcSlice[0] = 0;
        int j = 1;
        while (j < maxFunc) {
            int nSlice = 0;
            boolean prevAdc = false;
            int k = 0;
            while (k < 16 && this.times[j][k] != 0) {
                boolean adc = (this.lines[j][k] & 0x1000) != 0;
                if (adc & !prevAdc) {
                    ++nSlice;
                }
                prevAdc = adc;
                ++k;
            }
            funcSlice[j] = nSlice;
            ++j;
        }
        if (this.getVersion() == 0) {
            int nSlice = 0;
            int j2 = 0;
            while (j2 < this.stackSize) {
                int func = this.stack[j2] >> 28 & 3;
                int count = this.stack[j2] & 0x7FFFFFF;
                if (funcSlice[func] != 0 && (this.stack[j2] & 0x8000000) != 0) {
                    throw new REBException("Data-producing infinite loop");
                }
                nSlice += count * funcSlice[func];
                ++j2;
            }
            return nSlice;
        }
        return this.getProgSlices(0, 0, funcSlice);
    }

    private int getProgSlices(int addr, int level, int[] funcSlice) throws REBException {
        int nSlice = 0;
        while (addr < 1024) {
            int cmnd = this.prog[addr];
            switch (cmnd >>> 28) {
                case 1: {
                    int func = cmnd >> 24 & 0xF;
                    if (funcSlice[func] != 0 && (cmnd & 0x800000) != 0) {
                        throw new REBException("Data-producing infinite loop");
                    }
                    nSlice += (cmnd & 0x7FFFFF) * funcSlice[func];
                    break;
                }
                case 2: {
                    if (level >= 16) {
                        throw new REBException("Maximum subroutine level exceeded");
                    }
                    int sAddr = cmnd >> 18 & 0x3FF;
                    int count = cmnd & 0x1FFFF;
                    int slice = this.getProgSlices(sAddr, level + 1, funcSlice);
                    nSlice += slice >= 0 ? count * slice : 0xFFFFFFFF ^ slice;
                    if (slice >= 0) break;
                    return nSlice ^ (level == 0 ? 0 : -1);
                }
                case 3: {
                    if (level == 0) {
                        throw new REBException("Subroutine trailer at top level");
                    }
                    return nSlice;
                }
                case 4: {
                    return nSlice ^ (level == 0 ? 0 : -1);
                }
                default: {
                    throw new REBException("Invalid sequencer opcode (" + (cmnd >>> 28) + ")");
                }
            }
            ++addr;
        }
        if (level == 0) {
            throw new REBException("Missing end of program");
        }
        throw new REBException("Missing subroutine trailer");
    }

    private void checkFunc(int func) throws REBException {
        int maxFunc;
        int n = maxFunc = this.getVersion() == 0 ? 4 : 16;
        if (func < 0 || func >= maxFunc) {
            throw new REBException("Invalid function number");
        }
    }

    private void checkSlice(int slice) throws REBException {
        if (slice < 0 || slice >= 16) {
            throw new REBException("Invalid time slice number");
        }
    }

    private void checkStackAddr(int addr) throws REBException {
        if (addr < 0 || addr >= 4096) {
            throw new REBException("Invalid stack address");
        }
    }

    private void checkStackAddr(int addr, int count) throws REBException {
        if (addr < 0 || count <= 0 || addr + count > 4096) {
            throw new REBException("Invalid stack address");
        }
    }

    private void checkProgAddr(int addr) throws REBException {
        if (addr < 0 || addr >= 1024) {
            throw new REBException("Invalid program address");
        }
    }

    private void checkProgAddr(int addr, int count) throws REBException {
        if (addr < 0 || count <= 0 || addr + count > 1024) {
            throw new REBException("Invalid program address");
        }
    }
}

