/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class REBCommands {
    int version;
    Map<String, Integer> addresses = new HashMap<String, Integer>();

    public REBCommands(String file) {
        try {
            this.parseHDL(new File(file));
        }
        catch (IOException e) {
            throw new RuntimeException("error reading HDL file " + file, e);
        }
    }

    protected void parseHDL(File f) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(f));
        this.parseHDL(r);
    }

    protected void parseHDL(BufferedReader r) throws IOException {
        String line;
        Pattern p = Pattern.compile("\\s*constant\\s+([a-zA-Z0-9_]+)\\s+:std_logic_vector\\([0-9a-z ]+\\)\\s*:=\\s*x\"([0-9a-f]+)\".*");
        while ((line = r.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            String key = m.group(1);
            String hex = m.group(2);
            Integer value = Integer.valueOf(hex, 16);
            System.out.println(line);
            this.addresses.put(key, value);
        }
        r.close();
    }

    public static void main(String[] args) {
        new REBCommands(args[0]);
    }

    int getAddress(String key) {
        return this.addresses.get(key);
    }
}

