/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class BoardDacs
extends BaseSet {
    public static final int REG_BOARD_DACS = 0x400000;
    public static final int REG_BOARD_DACS_0 = 0x500001;
    public static final int DACS_SET = 0;
    public static final int DACS_LOAD = 1;
    public static final int DACS_INCR = 16;
    public static final int DAC_CLOCK_RAILS = 0;
    public static final int DAC_CS_GATE = 1;
    public static final int NUM_BOARD_DACS = 2;
    public static final int NUM_BOARD_DACS_0 = 1;
    public static final int CHAN_SCLK_L = 0;
    public static final int CHAN_SCLK_H = 1;
    public static final int CHAN_RG_L = 2;
    public static final int CHAN_RG_H = 3;
    public static final int CHAN_PCLK_L = 4;
    public static final int CHAN_PCLK_H = 5;
    public static final int CHAN_HEATER_1 = 6;
    public static final int CHAN_HEATER_2 = 7;
    public static final int CHAN_CSGATE_1 = 0;
    public static final int CHAN_CSGATE_2 = 1;
    public static final int CHAN_CSGATE_3 = 2;
    public static final int NUM_CLOCKS = 6;
    public static final int NUM_HEATERS = 2;
    public static final int NUM_CSGATES = 3;
    public static final int NUM_DAC_CHANNELS = 8;

    public BoardDacs() {
    }

    public BoardDacs(RegClient reg) {
        super(reg);
    }

    public void load(int dac) throws REBException {
        int base = this.getBase(dac);
        if (this.getVersion() == 0) {
            return;
        }
        this.write(base + 1, 0);
    }

    public void set(int dac, int chan, int value) throws REBException {
        int base = this.getBase(dac);
        this.checkChannel(chan);
        this.write(base + 0, chan << 12 | value & 0xFFF);
    }

    public void set(int dac, int chan, int[] value) throws REBException {
        int base = this.getBase(dac);
        this.checkChannel(chan, value.length);
        int j = 0;
        while (j < value.length) {
            this.write(base + 0, chan + j << 12 | value[j] & 0xFFF);
            ++j;
        }
    }

    private int getBase(int dac) throws REBException {
        int nDacs;
        int base;
        if (this.getVersion() == 0) {
            base = 0x500001;
            nDacs = 1;
        } else {
            base = 0x400000;
            nDacs = 2;
        }
        if (dac < 0 || dac >= nDacs) {
            throw new REBException("Invalid DAC number");
        }
        return base + dac * 16;
    }

    private void checkChannel(int chan) throws REBException {
        if (chan < 0 || chan >= 8) {
            throw new REBException("Invalid DAC channel number");
        }
    }

    private void checkChannel(int chan, int count) throws REBException {
        if (chan < 0 || count <= 0 || chan + count > 8) {
            throw new REBException("Invalid DAC channel number");
        }
    }
}

