/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class BaseSet
extends RegClient {
    public static final int RSET_STATUS = 0;
    public static final int RSET_TIME_BASE = 1;
    public static final int RSET_SEQUENCER = 2;
    public static final int RSET_POWER_ADCS = 3;
    public static final int RSET_TEMP_ADCS = 4;
    public static final int REG_SCHEMA = 0;
    public static final int REG_VERSION = 1;
    public static final int REG_ID = 2;
    public static final int REG_TIME_BASE = 4;
    public static final int REG_STATE = 8;
    public static final int REG_TRIGGER = 9;
    public static final int REG_TRIG_TIME = 10;
    public static final int REG_SN_REB_START = 0x800000;
    public static final int REG_SN_REB_VALUE = 0x800001;
    public static final int REG_SN_DREB_START = 0x800010;
    public static final int REG_SN_DREB_VALUE = 0x800011;
    public static final int REG_DCDC_SYNC = 0x900000;
    public static final int VERSION_CURR = -3;
    public static final int VERSION_UNSET = -2;
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_0 = 0;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int CLOCK_PERIOD_0 = 5;
    public static final int CLOCK_PERIOD_1 = 10;
    public static final long SN_READ_OKAY = 0x1000000000000L;
    public static final long SN_READ_ERROR = 0x2000000000000L;
    public static final long SN_READ_TIMEOUT = 0x4000000000000L;
    public static final long SN_VALUE_MASK = 0xFFFFFFFFFFFFL;
    private static final int WAIT_TIMEOUT = 1000;
    private int version = -2;
    private int handleInst;

    public BaseSet() {
    }

    public BaseSet(RegClient reg) {
        this.handle = reg.handle;
    }

    public int getVersion() throws REBException {
        try {
            this.checkOpen();
        }
        catch (REBException e) {
            this.version = -2;
            throw e;
        }
        if (this.version == -2 || this.handleInst != this.handle.instance) {
            this.handleInst = this.handle.instance;
            int schema = this.read(0);
            this.read(1);
            if (schema == 15851008) {
                this.version = 0;
            } else if (schema == 1) {
                this.version = 1;
            } else if (schema == 2) {
                this.version = 2;
            } else if (schema == 3) {
                this.version = 3;
            } else {
                this.version = -1;
                throw new REBException("Unknown firmware version");
            }
        }
        return this.version;
    }

    public void checkVersion(int version) throws REBException {
        if (this.getVersion() != version) {
            throw new REBException("Incompatible firmware version");
        }
    }

    public void checkVersion(int lowvers, int highvers) throws REBException {
        if (this.getVersion() < lowvers || highvers != -3 && this.getVersion() > highvers) {
            throw new REBException("Incompatible firmware version");
        }
    }

    public void checkNotVersion(int version) throws REBException {
        if (this.getVersion() == version) {
            throw new REBException("Incompatible firmware version");
        }
    }

    public void enable() throws REBException {
        this.enable(1);
    }

    public void disable() throws REBException {
        this.disable(1);
    }

    public long getTimeRaw() throws REBException {
        return this.readLong(4);
    }

    public long getTime() throws REBException {
        return (long)this.getPeriod() * this.getTimeRaw() / 1000000L;
    }

    public void setTimeRaw(long time) throws REBException {
        this.writeLong(4, time);
    }

    public void setTime(long time) throws REBException {
        this.setTimeRaw(1000000L * time / (long)this.getPeriod());
    }

    public void setTime() throws REBException {
        this.setTime(System.currentTimeMillis());
    }

    public void enable(int regSet) throws REBException {
        this.write(9, this.read(8) & 3 | 1 << regSet);
    }

    public void disable(int regSet) throws REBException {
        this.write(9, this.read(8) & 3 & ~(1 << regSet));
    }

    public void waitDone(int regSet) throws REBException {
        long limit = System.currentTimeMillis() + 1000L;
        boolean busy = true;
        while (busy && System.currentTimeMillis() < limit) {
            boolean bl = busy = (this.read(8) & 1 << regSet) != 0;
        }
        if (busy) {
            throw new REBException("Completion wait timeout");
        }
    }

    public long getTriggerTimeRaw(int regSet) throws REBException {
        return this.readLong(10 + 2 * regSet);
    }

    public long getTriggerTime(int regSet) throws REBException {
        return (long)this.getPeriod() * this.getTriggerTimeRaw(regSet) / 1000000L;
    }

    public long getRebSN() throws REBException {
        this.checkVersion(3, -3);
        this.write(0x800000, 0);
        long value = this.readLong(0x800001);
        if ((value & 0x1000000000000L) == 0L) {
            String problem = (value & 0x2000000000000L) != 0L ? "error" : "timeout";
            throw new REBException("Serial number read " + problem);
        }
        return value & 0xFFFFFFFFFFFFL;
    }

    public long getDrebSN() throws REBException {
        this.checkVersion(3, -3);
        this.write(0x800010, 0);
        long value = this.readLong(0x800011);
        if ((value & 0x1000000000000L) == 0L) {
            String problem = (value & 0x2000000000000L) != 0L ? "error" : "timeout";
            throw new REBException("Serial number read " + problem);
        }
        return value & 0xFFFFFFFFFFFFL;
    }

    public void setDcdcSync(boolean enable) throws REBException {
        this.checkVersion(3, -3);
        this.write(0x900000, enable ? 1 : 0);
    }

    public boolean isDcdcSync() throws REBException {
        this.checkVersion(3, -3);
        return (this.read(0x900000) & 1) != 0;
    }

    private int getPeriod() throws REBException {
        return this.getVersion() == 0 ? 5 : 10;
    }
}

