/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import java.io.IOException;
import java.io.PrintStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.rcm.BaseSet;
import org.lsst.ccs.drivers.rcm.BoardDacs;
import org.lsst.ccs.drivers.rcm.PowerAdcs;
import org.lsst.ccs.drivers.rcm.RcmException;
import org.lsst.ccs.drivers.rcm.SequencerUtils;
import org.lsst.ccs.drivers.rcm.Status;
import org.lsst.ccs.drivers.rcm.StatusSet;
import org.lsst.ccs.drivers.rcm.TempAdcs;
import org.lsst.ccs.utilities.sa.CmndProcess;

public class TestRegOld
implements CmndProcess.Dispatch {
    private static final int CMD_CONNECT = 0;
    private static final int CMD_SHOW = 1;
    private static final int CMD_READ = 2;
    private static final int CMD_WRITE = 3;
    private static final int CMD_UPDATE = 4;
    private static final int CMD_READLONG = 5;
    private static final int CMD_WRITELONG = 6;
    private static final int CMD_ENABLE = 7;
    private static final int CMD_DISABLE = 8;
    private static final int CMD_TRIGTIME = 9;
    private static final int CMD_TIMEBASE = 10;
    private static final int CMD_LOADTEST = 11;
    private static final int CMD_LOADCMND = 12;
    private static final int CMD_LOADFILE = 13;
    private static final int CMD_STATUS = 14;
    private static final int CMD_TIME = 15;
    private static final int CMD_DISCONN = 16;
    private static final int CMD_TEMP = 17;
    private static final int CMD_POWER = 18;
    private static final int CMD_DAC = 19;
    private static final int CMD_CONTREAD = 20;
    private static final int CMD_CONTTEMP = 21;
    private static final int CMD_CONTPOWER = 22;
    private static final int NUM_CMDS = 23;
    private static final String[] helpConnect = new String[]{"Connect to an RCM", "connect <id> [<ifc>]", "id   The id of the RCM", "ifc  The name of the network interface to use"};
    private static final String[] helpDisconn = new String[]{"Disconnect from an RCM", "disconnect"};
    private static final String[] helpShow = new String[]{"Show the current connection parameters", "show"};
    private static final String[] helpRead = new String[]{"Read and display registers from the RCM", "read <address> [<count>]", "address  The address of the first register to read", "count    The number of registers to read (default 1)"};
    private static final String[] helpReadlong = new String[]{"Read and display a register pair from the RCM", "read <address>", "address  The address of the register pair to read"};
    private static final String[] helpWrite = new String[]{"Write to registers on the RCM", "write <address> <value1> [<value2>]... [<value8>]", "address  The address of the first register to write", "valuen   The value(s) to write"};
    private static final String[] helpWritelong = new String[]{"Write to a register pair on the RCM", "write <address> <value>", "address  The address of the register pair", "value    The value to write"};
    private static final String[] helpUpdate = new String[]{"Update a register on the RCM", "update <address> <mask> <value>", "address  The address of the register to update", "mask     The mask of bits to change", "value    The value to write under the mask"};
    private static final String[] helpEnable = new String[]{"Enable a register set on the RCM", "enable <regset>", "regset  The name or number of the register set"};
    private static final String[] helpDisable = new String[]{"Disable a register set on the RCM", "disable <regset>", "regset  The name or number of the register set"};
    private static final String[] helpTrigtime = new String[]{"Display the trigger time for a register set on the RCM", "trigtime <regset> <raw>", "regset  The name or number of the register set", "raw     If present (value ignored), displays the raw value"};
    private static final String[] helpTime = new String[]{"Set or show the time on the RCM, as time of day", "time [<value>]", "value  If present (yyyy-mm-dd hh:mm:ss or '.' for current time),", "       the time is set; otherwise it is shown"};
    private static final String[] helpTimebase = new String[]{"Set or show the time on the RCM, as a raw value", "timebase [<value>]", "value  If present (long), the time is set; otherwise it is shown"};
    private static final String[] helpLoadtest = new String[]{"Load the RCM sequencer with a basic test sequence", "loadtest <tottime> <ncycle> [<ontime>]", "tottime  Time for each ADC on/off cycle (10 ns ticks)", "ncycle   The number of on/off cycles to perform", "ontime   Time the ADC trigger is on (10 ns ticks, default 10)"};
    private static final String[] helpLoadcmnd = new String[]{"Load a command into the RCM sequencer", "loadcmnd command", "command  A sequencer text command"};
    private static final String[] helpLoadfile = new String[]{"Load the RCM sequencer from a file of commands", "loadfile file", "file  The name of a file containing sequencer text commands"};
    private static final String[] helpStatus = new String[]{"Display the contents of the RCM status block", "status"};
    private static final String[] helpTemp = new String[]{"Display board temperatures", "temp [first] [count]", "first  The first temperature to read (default 0)", "count  The number of temperatures to read (default 1 or all)"};
    private static final String[] helpPower = new String[]{"Display board power (voltage and current) values", "power [first] [count]", "first  The first power value to read(default 0)", "count  The number of power values to read (default 1 or all)"};
    private static final String[] helpDac = new String[]{"Set a REB board DAC value", "dac number chan value", "number  The number of the DAC to set (0 or 1)", "chan    The number of the channel to set (0 - 7)", "value   The value to set"};
    private static final String[] helpContread = new String[]{"Continuously read registers from the RCM", "contread <address> [<count>]", "address  The address of the first register to read", "count    The number of registers to read (default 1)"};
    private static final String[] helpConttemp = new String[]{"Conrinuously read board temperatures", "conttemp"};
    private static final String[] helpContpower = new String[]{"Conrinuously read board power values", "contpower"};
    private static final CmndProcess.Lookup rsetNames = new CmndProcess.Lookup(5);
    private static final CmndProcess.Command cmnd;
    private static final PrintStream out;
    private final CmndProcess proc = new CmndProcess();
    private final BaseSet bset = new BaseSet();
    private final SequencerUtils seq = new SequencerUtils(this.bset);
    private final StatusSet sset = new StatusSet(this.bset);
    private final TempAdcs tmp = new TempAdcs(this.bset);
    private final PowerAdcs pwr = new PowerAdcs(this.bset);
    private final BoardDacs dac = new BoardDacs(this.bset);
    private int rcmId = -1;
    private boolean contActive;
    private BlockingQueue<Integer> consQueue = new ArrayBlockingQueue<Integer>(1);

    static {
        rsetNames.add("status", 0);
        rsetNames.add("timebase", 1);
        rsetNames.add("sequencer", 2);
        rsetNames.add("poweradcs", 3);
        rsetNames.add("tempadcs", 4);
        cmnd = new CmndProcess.Command(23);
        cmnd.add("connect", 0, helpConnect, "Is", new CmndProcess.Lookup[0]);
        cmnd.add("disconnect", 16, helpDisconn, "", new CmndProcess.Lookup[0]);
        cmnd.add("show", 1, helpShow, "", new CmndProcess.Lookup[0]);
        cmnd.add("read", 2, helpRead, "Ii", new CmndProcess.Lookup[0]);
        cmnd.add("write", 3, helpWrite, "IIiiiiiii", new CmndProcess.Lookup[0]);
        cmnd.add("update", 4, helpUpdate, "III", new CmndProcess.Lookup[0]);
        cmnd.add("readlong", 5, helpReadlong, "I", new CmndProcess.Lookup[0]);
        cmnd.add("writelong", 6, helpWritelong, "IL", new CmndProcess.Lookup[0]);
        cmnd.add("enable", 7, helpEnable, "J", new CmndProcess.Lookup[]{rsetNames});
        cmnd.add("disable", 8, helpDisable, "J", new CmndProcess.Lookup[]{rsetNames});
        cmnd.add("trigtime", 9, helpTrigtime, "Js", new CmndProcess.Lookup[]{rsetNames});
        cmnd.add("time", 15, helpTime, "s", new CmndProcess.Lookup[0]);
        cmnd.add("timebase", 10, helpTimebase, "l", new CmndProcess.Lookup[0]);
        cmnd.add("loadtest", 11, helpLoadtest, "IIi", new CmndProcess.Lookup[0]);
        cmnd.add("loadcmnd", 12, helpLoadcmnd, "E", new CmndProcess.Lookup[0]);
        cmnd.add("loadfile", 13, helpLoadfile, "S", new CmndProcess.Lookup[0]);
        cmnd.add("status", 14, helpStatus, "", new CmndProcess.Lookup[0]);
        cmnd.add("temp", 17, helpTemp, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("power", 18, helpPower, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("dac", 19, helpDac, "III", new CmndProcess.Lookup[0]);
        cmnd.add("contread", 20, helpContread, "Ii", new CmndProcess.Lookup[0]);
        cmnd.add("conttemp", 21, helpConttemp, "", new CmndProcess.Lookup[0]);
        cmnd.add("contpower", 22, helpContpower, "", new CmndProcess.Lookup[0]);
        out = System.out;
    }

    public static void main(String[] args) {
        new TestRegOld().run();
        System.exit(0);
    }

    public void run() {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        new ConsThread().start();
        try {
            String line;
            ConsoleReader reader = new ConsoleReader();
            while ((line = reader.readLine(">> ")) != null && this.proc.process(line)) {
            }
        }
        catch (IOException e) {
            out.println(e);
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        try {
            switch (code) {
                case 0: {
                    this.procConnect(found, args);
                    break;
                }
                case 16: {
                    this.procDisconn(found, args);
                    break;
                }
                case 1: {
                    this.procShow(found, args);
                    break;
                }
                case 2: {
                    this.procRead(found, args);
                    break;
                }
                case 3: {
                    this.procWrite(found, args);
                    break;
                }
                case 4: {
                    this.procUpdate(found, args);
                    break;
                }
                case 5: {
                    this.procReadLong(found, args);
                    break;
                }
                case 6: {
                    this.procWriteLong(found, args);
                    break;
                }
                case 7: {
                    this.procEnable(found, args);
                    break;
                }
                case 8: {
                    this.procDisable(found, args);
                    break;
                }
                case 9: {
                    this.procTrigtime(found, args);
                    break;
                }
                case 15: {
                    this.procTime(found, args);
                    break;
                }
                case 10: {
                    this.procTimebase(found, args);
                    break;
                }
                case 11: {
                    this.procLoadtest(found, args);
                    break;
                }
                case 12: {
                    this.procLoadcmnd(found, args);
                    break;
                }
                case 13: {
                    this.procLoadfile(found, args);
                    break;
                }
                case 14: {
                    this.procStatus(found, args);
                    break;
                }
                case 17: {
                    this.procTemp(found, args);
                    break;
                }
                case 18: {
                    this.procPower(found, args);
                    break;
                }
                case 19: {
                    this.procDac(found, args);
                    break;
                }
                case 20: {
                    this.procContread(found, args);
                    break;
                }
                case 21: {
                    this.procConttemp(found, args);
                    break;
                }
                case 22: {
                    this.procContpower(found, args);
                    break;
                }
                default: {
                    out.println("Command not fully implemented");
                    break;
                }
            }
        }
        catch (RcmException e) {
            out.println((Object)e);
        }
        return true;
    }

    private void procConnect(int found, Object[] args) throws RcmException {
        this.rcmId = (Integer)args[0];
        if ((found & 2) == 0) {
            this.bset.open(this.rcmId);
        } else {
            this.bset.open(this.rcmId, (String)args[1]);
        }
    }

    private void procDisconn(int found, Object[] args) throws RcmException {
        this.bset.close();
        this.rcmId = -1;
    }

    private void procShow(int found, Object[] args) {
        boolean connected = false;
        int version = -1;
        try {
            this.bset.checkOpen();
            connected = true;
        }
        catch (RcmException rcmException) {}
        try {
            version = this.bset.getVersion();
        }
        catch (RcmException rcmException) {}
        out.println("Connection parameters:");
        out.format("  Connected  = %s\n", connected);
        out.format("  RCM id     = %s\n", this.rcmId);
        out.format("  Version    = %s\n", version);
    }

    private void procRead(int found, Object[] args) throws RcmException {
        int address = (Integer)args[0];
        if ((found & 2) == 0) {
            out.format("%06x: %08x\n", address, this.bset.read(address));
        } else {
            int count = (Integer)args[1];
            int[] values = new int[count];
            this.bset.read(address, values);
            int j = 0;
            while (j < count) {
                if ((j & 3) == 0) {
                    if (j != 0) {
                        out.println();
                    }
                    out.format("%06x:", address);
                }
                out.format(" %08x", values[j]);
                ++j;
                ++address;
            }
            if (count > 0) {
                out.println();
            }
        }
    }

    private void procWrite(int found, Object[] args) throws RcmException {
        int address = (Integer)args[0];
        int[] values = new int[8];
        int count = 0;
        int j = 1;
        while (j <= 8) {
            if ((found & 1 << j) != 0) {
                values[count++] = (Integer)args[j];
            }
            ++j;
        }
        if (count == 1) {
            this.bset.write(address, values[0]);
        } else {
            this.bset.write(address, values);
        }
    }

    private void procUpdate(int found, Object[] args) throws RcmException {
        this.bset.update((Integer)args[0], (Integer)args[1], (Integer)args[2]);
    }

    private void procReadLong(int found, Object[] args) throws RcmException {
        int address = (Integer)args[0];
        out.format("%06x: %016x\n", address, this.bset.readLong(address));
    }

    private void procWriteLong(int found, Object[] args) throws RcmException {
        this.bset.writeLong((Integer)args[0], (Long)args[1]);
    }

    private void procEnable(int found, Object[] args) throws RcmException {
        this.bset.enable((Integer)args[0]);
    }

    private void procDisable(int found, Object[] args) throws RcmException {
        this.bset.disable((Integer)args[0]);
    }

    private void procTrigtime(int found, Object[] args) throws RcmException {
        if ((found & 2) != 0) {
            long time = this.bset.getTriggerTimeRaw((Integer)args[0]);
            out.println("Value = " + time);
        } else {
            long time = this.bset.getTriggerTime((Integer)args[0]);
            GregorianCalendar tm = new GregorianCalendar();
            tm.setTimeInMillis(time);
            out.format("Time = %tY-%<tm-%<td %<tH:%<tM:%<tS.%<tL\n", tm);
        }
    }

    private void procTime(int found, Object[] args) throws RcmException {
        if (found == 0) {
            long time = this.bset.getTime();
            GregorianCalendar tm = new GregorianCalendar();
            tm.setTimeInMillis(time);
            out.format("Time = %tY-%<tm-%<td %<tH:%<tM:%<tS.%<tL\n", tm);
        } else {
            String time = (String)args[0];
            if (time.equals(".")) {
                this.bset.setTime();
            } else {
                SimpleDateFormat fmt = new SimpleDateFormat();
                fmt.setLenient(true);
                fmt.applyPattern("y-M-d H:m:s");
                ParsePosition pos = new ParsePosition(0);
                Date date = fmt.parse(time, pos);
                if (date == null) {
                    out.println("Expected format is yyyy-mm-dd hh:mm:ss");
                } else {
                    this.bset.setTime(date.getTime());
                }
            }
        }
    }

    private void procTimebase(int found, Object[] args) throws RcmException {
        if (found == 0) {
            out.println("Value = " + this.bset.getTimeRaw());
        } else {
            this.bset.setTimeRaw((Long)args[0]);
        }
    }

    private void procLoadtest(int found, Object[] args) throws RcmException {
        int totTime = (Integer)args[0];
        int ncycle = (Integer)args[1];
        int onTime = (found & 4) != 0 ? (Integer)args[2] : 10;
        this.seq.writeLines(0, new int[1]);
        int[] nArray = new int[2];
        nArray[0] = 4096;
        this.seq.writeLines(1, nArray);
        int[] nArray2 = new int[3];
        nArray2[0] = onTime;
        nArray2[1] = totTime - onTime;
        this.seq.writeTimes(1, nArray2);
        if (this.seq.getVersion() == 0) {
            this.seq.writeStack(new int[]{0x10000000 | ncycle & 0x3FFFFFF});
            this.seq.writeDataSource(0);
        } else {
            this.seq.writeProgExec(0, 1, ncycle);
            this.seq.writeProgEnd(1);
            this.seq.writeDataSource(1);
        }
        this.seq.writeSliceCount(ncycle);
    }

    private void procLoadcmnd(int found, Object[] args) throws RcmException {
        this.seq.loadCommand((String)args[0]);
    }

    private void procLoadfile(int found, Object[] args) throws RcmException {
        try {
            int nSlice = this.seq.loadFile((String)args[0]);
            out.println("Slice count = " + nSlice);
        }
        catch (IOException e) {
            out.println(e);
        }
    }

    private void procStatus(int found, Object[] args) throws RcmException {
        Status status = this.sset.readStatus();
        out.println("Status Block:");
        out.format("  Version          = %08x  ", status.getVersion());
        out.format("  Link Status      = %08x\n", status.getLinkStatus());
        out.format("  Cell error count = %-8s  ", status.getCellErrorCount());
        out.format("  Link down count  = %s\n", status.getLinkDownCount());
        out.format("  Link error count = %-8s  ", status.getLinkErrorCount());
        out.format("  VC buffer status = %08x\n", status.getVcBufferStatus());
        int[] counts = status.getVcRxCounts();
        out.format("  VC rcve counts   =", new Object[0]);
        int j = 0;
        while (j < counts.length) {
            out.format(" %s", counts[j]);
            ++j;
        }
        out.println();
        counts = status.getVcTxCounts();
        out.format("  VC xmit counts   =", new Object[0]);
        j = 0;
        while (j < counts.length) {
            out.format(" %s", counts[j]);
            ++j;
        }
        out.println();
    }

    private void procTemp(int found, Object[] args) throws RcmException {
        int first = 0;
        float[] values = null;
        switch (found & 3) {
            case 1: {
                values = new float[]{this.tmp.readAdc((Integer)args[0])};
                break;
            }
            case 0: {
                values = this.tmp.readAdcs();
                break;
            }
            case 3: {
                first = (Integer)args[0];
            }
            case 2: {
                values = this.tmp.readAdcs(first, (Integer)args[1]);
            }
        }
        int j = 0;
        while (j < values.length) {
            if ((j & 3) == 0) {
                out.print(j == 0 ? "ADCs:" : "\n     ");
            }
            out.format("  %2s: %6g", j + first, Float.valueOf(values[j]));
            ++j;
        }
        out.println();
    }

    private void procPower(int found, Object[] args) throws RcmException {
        int first = 0;
        float[] values = null;
        switch (found & 3) {
            case 1: {
                values = new float[]{this.pwr.readAdc((Integer)args[0])};
                break;
            }
            case 0: {
                values = this.pwr.readAdcs();
                break;
            }
            case 3: {
                first = (Integer)args[0];
            }
            case 2: {
                values = this.pwr.readAdcs(first, (Integer)args[1]);
            }
        }
        int j = 0;
        while (j < values.length) {
            if ((j & 3) == 0) {
                out.print(j == 0 ? "ADCs:" : "\n     ");
            }
            out.format("  %2s: %6g", j + first, Float.valueOf(values[j]));
            ++j;
        }
        out.println();
    }

    private void procDac(int found, Object[] args) throws RcmException {
        this.dac.set((int)((Integer)args[0]), (int)((Integer)args[1]), (Integer)args[2]);
    }

    private void procContread(int found, Object[] args) throws RcmException {
        int address = (Integer)args[0];
        int count = (found & 2) == 0 ? 1 : (Integer)args[1];
        int[] values = new int[count];
        int nRead = 0;
        long startTime = System.currentTimeMillis();
        out.println("Press any key to terminate...");
        this.contActive = true;
        this.consQueue.offer(0);
        try {
            while (this.contActive) {
                this.bset.read(address, values);
                nRead += count;
            }
        }
        catch (Throwable throwable) {
            double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
            out.format("Read rate = %.4g Hz\n", rate);
            throw throwable;
        }
        double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
        out.format("Read rate = %.4g Hz\n", rate);
    }

    private void procConttemp(int found, Object[] args) throws RcmException {
        int nRead = 0;
        long startTime = System.currentTimeMillis();
        out.println("Press any key to terminate...");
        this.contActive = true;
        this.consQueue.offer(0);
        try {
            while (this.contActive) {
                this.tmp.readAdcs();
                ++nRead;
            }
        }
        catch (Throwable throwable) {
            double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
            out.format("Read rate = %.4g Hz\n", rate);
            throw throwable;
        }
        double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
        out.format("Read rate = %.4g Hz\n", rate);
    }

    private void procContpower(int found, Object[] args) throws RcmException {
        int nRead = 0;
        long startTime = System.currentTimeMillis();
        out.println("Press any key to terminate...");
        this.contActive = true;
        this.consQueue.offer(0);
        try {
            while (this.contActive) {
                this.pwr.readAdcs();
                ++nRead;
            }
        }
        catch (Throwable throwable) {
            double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
            out.format("Read rate = %.4g Hz\n", rate);
            throw throwable;
        }
        double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
        out.format("Read rate = %.4g Hz\n", rate);
    }

    private static void take(BlockingQueue queue) {
        while (true) {
            try {
                queue.take();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static void awaitTerminal() {
        while (true) {
            try {
                while (true) {
                    if (System.in.available() > 0) {
                        return;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private static void clearTerminal() {
        try {
            while (System.in.available() > 0) {
                System.in.read();
            }
        }
        catch (IOException iOException) {}
    }

    class ConsThread
    extends Thread {
        ConsThread() {
        }

        @Override
        public void run() {
            block0: while (true) {
                TestRegOld.take(TestRegOld.this.consQueue);
                while (true) {
                    if (!TestRegOld.this.contActive) continue block0;
                    TestRegOld.awaitTerminal();
                    if (TestRegOld.this.contActive) {
                        TestRegOld.clearTerminal();
                    }
                    TestRegOld.this.contActive = false;
                }
                break;
            }
        }
    }
}

