/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import org.lsst.ccs.drivers.rcm.BaseSet;
import org.lsst.ccs.drivers.rcm.RcmException;
import org.lsst.ccs.drivers.rcm.RegClient;

public class TempRtds
extends BaseSet {
    public static final int REG_RTD_COMMAND = 0x700000;
    public static final int REG_RTD_REPLY = 0x700001;
    public static final int NUM_RTD_TEMPS = 4;

    public TempRtds() {
    }

    public TempRtds(RegClient reg) {
        super(reg);
    }

    public void writeCommand(int value) throws RcmException {
        this.write(0x700000, value);
    }

    public int readReply() throws RcmException {
        return this.read(0x700001);
    }

    public float readRtd(int rtd) throws RcmException {
        if (rtd < 0 || rtd >= 4) {
            throw new RcmException("Invalid temperature RTD number");
        }
        return 0.0f;
    }
}

