/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import org.lsst.ccs.drivers.rcm.BaseSet;
import org.lsst.ccs.drivers.rcm.RcmException;
import org.lsst.ccs.drivers.rcm.RegClient;

public class TempAdcs
extends BaseSet {
    public static final int REG_TEMP_ADCS = 0x600010;
    public static final int ADC_DREB_T1 = 0;
    public static final int ADC_DREB_T2 = 1;
    public static final int ADC_REB_T1 = 2;
    public static final int ADC_REB_T2 = 3;
    public static final int ADC_REB_T3 = 4;
    public static final int ADC_REB_T4 = 5;
    public static final int ADC_REB_T5 = 6;
    public static final int ADC_REB_T6 = 7;
    public static final int ADC_REB_T7 = 8;
    public static final int ADC_REB_T8 = 9;
    public static final int ADC_REB_T9 = 10;
    public static final int NUM_TEMP_REGS = 11;
    public static final int ERROR_MASK = 65536;
    public static final int VALUE_MASK = 65535;
    public static final float TEMP_SCALE = 0.0078125f;
    public static final float TEMP_ERROR = -8888.0f;

    public TempAdcs() {
    }

    public TempAdcs(RegClient reg) {
        super(reg);
    }

    @Override
    public void enable() throws RcmException {
        this.checkNotVersion(0);
        this.enable(4);
    }

    public void waitDone() throws RcmException {
        this.checkNotVersion(0);
        this.waitDone(4);
    }

    public long getTriggerTime() throws RcmException {
        this.checkVersion(2, -3);
        return this.getTriggerTime(4);
    }

    public float readAdc(int adc) throws RcmException {
        if (adc < 0 || adc >= 11) {
            throw new RcmException("Invalid temperature ADC number");
        }
        this.enable();
        this.waitDone();
        int value = this.read(0x600010 + adc);
        return (value & 0x10000) != 0 ? -8888.0f : 0.0078125f * (float)(value & 0xFFFF);
    }

    public float[] readAdcs() throws RcmException {
        return this.readAdcs(0, 11);
    }

    public float[] readAdcs(int first, int count) throws RcmException {
        if (first < 0 || count < 0 || first + count > 11) {
            throw new RcmException("Invalid temperature ADC range");
        }
        this.enable();
        this.waitDone();
        int[] rawData = new int[count];
        float[] data = new float[count];
        this.read(0x600010 + first, rawData);
        int j = 0;
        while (j < count) {
            int value = rawData[j];
            data[j] = (value & 0x10000) != 0 ? -8888.0f : 0.0078125f * (float)(value & 0xFFFF);
            ++j;
        }
        return data;
    }
}

