/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.lsst.ccs.drivers.rcm.RcmException;
import org.lsst.ccs.drivers.rcm.RegClient;
import org.lsst.ccs.drivers.rcm.Sequencer;

public class SequencerUtils
extends Sequencer {
    private static final int SEQTYPE_REGISTER = 0;
    private static final int SEQTYPE_OUTPUT = 1;
    private static final int SEQTYPE_TIMES = 2;
    private static final int SEQTYPE_PROGRAM = 3;
    private static final int SEQTYPE_PROGEXEC = 4;
    private static final int SEQTYPE_PROGJUMP = 5;
    private static final int SEQTYPE_PROGSUBE = 6;
    private static final int SEQTYPE_PROGEND = 7;
    private static final int SEQTYPE_SLICE = 8;
    private static final int SEQTYPE_SOURCE = 9;
    private static final int SEQTYPE_STACK = 10;
    private static final int SEQTYPE_BEB = 11;
    private static final Map<String, Integer> seqTypes = new HashMap<String, Integer>();
    private static final Map<Integer, Integer> seqMinArgs;
    private int stkSize;

    static {
        seqTypes.put("register", 0);
        seqTypes.put("output", 1);
        seqTypes.put("times", 2);
        seqTypes.put("program", 3);
        seqTypes.put("progexec", 4);
        seqTypes.put("progjump", 5);
        seqTypes.put("progsube", 6);
        seqTypes.put("progend", 7);
        seqTypes.put("slice", 8);
        seqTypes.put("source", 9);
        seqTypes.put("stack", 10);
        seqTypes.put("beb", 11);
        seqMinArgs = new HashMap<Integer, Integer>();
        seqMinArgs.put(0, 3);
        seqMinArgs.put(1, 3);
        seqMinArgs.put(2, 3);
        seqMinArgs.put(3, 3);
        seqMinArgs.put(4, 4);
        seqMinArgs.put(5, 4);
        seqMinArgs.put(6, 2);
        seqMinArgs.put(7, 2);
        seqMinArgs.put(8, 2);
        seqMinArgs.put(9, 2);
        seqMinArgs.put(10, 3);
        seqMinArgs.put(11, 2);
    }

    public SequencerUtils() {
    }

    public SequencerUtils(RegClient reg) {
        super(reg);
    }

    public void loadCommand(String cmnd) throws RcmException {
        this.loadCommand(cmnd, 0);
    }

    public void loadCommand(String cmnd, int lineNum) throws RcmException {
        boolean thrown = false;
        ArrayList<Integer> args = new ArrayList<Integer>();
        String word = "";
        try {
            Scanner scan = new Scanner(cmnd);
            int type = -1;
            int count = 0;
            args.clear();
            while (scan.hasNext()) {
                word = scan.next();
                if (count == 0) {
                    if (word.startsWith("#")) break;
                    Integer iType = seqTypes.get(word);
                    if (iType == null) {
                        thrown = true;
                        this.throwException("Invalid operation (" + word + ")", lineNum);
                    }
                    type = iType;
                } else {
                    args.add((int)Long.decode(word).longValue());
                }
                ++count;
            }
            if (count == 0) {
                return;
            }
            int minArgs = seqMinArgs.get(type);
            if (count < minArgs) {
                thrown = true;
                this.throwException("Too few arguments (" + (count - 1) + ")", lineNum);
            }
            if (minArgs != 3 && count > minArgs) {
                thrown = true;
                this.throwException("Too many arguments (" + (count - 1) + ")", lineNum);
            }
            int arg0 = (Integer)args.get(0);
            if (minArgs == 2) {
                if (type == 6) {
                    this.writeProgEndSubr(arg0);
                } else if (type == 7) {
                    this.writeProgEnd(arg0);
                } else if (type == 8) {
                    this.writeSliceCount(arg0);
                } else if (type == 9) {
                    this.writeDataSource(arg0);
                } else if (type == 11) {
                    this.writeBebSelect(arg0);
                }
            } else {
                int[] values = new int[count - 2];
                int j = 0;
                while (j < values.length) {
                    values[j] = (Integer)args.get(j + 1);
                    ++j;
                }
                if (type == 0) {
                    this.write(arg0, values);
                } else if (type == 1) {
                    this.writeLines(arg0, values);
                } else if (type == 2) {
                    this.writeTimes(arg0, values);
                } else if (type == 3) {
                    this.writeProgram(arg0, values);
                } else if (type == 4) {
                    this.writeProgExec(arg0, values[0], values[1]);
                } else if (type == 5) {
                    this.writeProgJump(arg0, values[0], values[1]);
                } else if (type == 10) {
                    this.writeStack(arg0, values);
                    if (arg0 + values.length > this.stkSize) {
                        this.stkSize = arg0 + values.length;
                        this.writeStackSize(this.stkSize);
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException("Invalid integer (" + word + ")", lineNum);
        }
        catch (RcmException e) {
            if (thrown) {
                throw e;
            }
            this.throwException(e.getMessage(), lineNum);
        }
    }

    public int loadFile(String fileName) throws RcmException, IOException {
        BufferedReader rdr = null;
        int lineNum = 0;
        this.stkSize = 0;
        this.clearCache();
        try {
            String line;
            rdr = new BufferedReader(new FileReader(fileName));
            while ((line = rdr.readLine()) != null) {
                this.loadCommand(line, ++lineNum);
            }
        }
        catch (Throwable throwable) {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (rdr != null) {
            try {
                rdr.close();
            }
            catch (IOException iOException) {}
        }
        return this.getCacheSliceCount();
    }

    private void throwException(String text, int lineNum) throws RcmException {
        if (lineNum > 0) {
            throw new RcmException(String.valueOf(text) + " at line " + lineNum);
        }
        throw new RcmException(text);
    }
}

