/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import java.nio.ByteBuffer;
import org.lsst.ccs.drivers.rcm.ImageClient;
import org.lsst.ccs.drivers.rcm.ImageMetadata;

public class Image
extends ImageMetadata {
    private long mdata;
    private ByteBuffer data;

    public Image() {
    }

    public Image(long tag, int length, int format, int schema, int version, int address, int cluster, int element, long mdata) {
        super(tag, length, format, schema, version, address, cluster, element);
        this.mdata = mdata;
    }

    public Image(long tag, int length, int format, int schema, int version, int address, int cluster, int element, ByteBuffer data) {
        super(tag, length, format, schema, version, address, cluster, element);
        this.data = data;
    }

    public ByteBuffer getData() {
        return this.data != null && this.data.limit() > 0 ? this.data.asReadOnlyBuffer() : null;
    }

    public ImageMetadata getMetadata() {
        return new ImageMetadata(this.tag, this.length, this.format, this.schema, this.version, this.address, this.cluster, this.element);
    }

    public void deleteMetadataRef() {
        if (this.mdata != 0L) {
            ImageClient.deleteImageMetadataRef(this);
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.deleteMetadataRef();
    }
}

