package org.lsst.ccs.drivers.rcm;

/**
 ***************************************************************************
 **
 **  Sensor RTDs reading routines.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class TempRtds extends BaseSet {

   /**
    ***************************************************************************
    **
    **  Public constants
    **
    ***************************************************************************
    */
    public final static int
        REG_RTD_COMMAND = 0x700000,
        REG_RTD_REPLY   = 0x700001,
        NUM_RTD_TEMPS   = 4;
 

   /**
    ***************************************************************************
    **
    **  Constructors.
    **
    ***************************************************************************
    */
    public TempRtds()
    {
        super();
    }

    public TempRtds(RegClient reg)
    {
        super(reg);
    }


   /**
    ***************************************************************************
    **
    **  Writes a command.
    **
    **  @param  command  The command to write
    **
    **  @exception  RcmException 
    **
    ***************************************************************************
    */
    public void writeCommand(int value) throws RcmException
    {
        write(REG_RTD_COMMAND, value);
    }


   /**
    ***************************************************************************
    **
    **  Reads a reply.
    **
    **  @return  The read reply
    **
    **  @exception  RcmException 
    **
    ***************************************************************************
    */
    public int readReply() throws RcmException
    {
        return read(REG_RTD_REPLY);
    }


   /**
    ***************************************************************************
    **
    **  Reads one temperature value.
    **
    **  @param  rtd  The number of the RTD to read
    **
    **  @return  The RTD value (Celsius)
    **
    **  @exception  RcmException 
    **
    ***************************************************************************
    */
    public float readRtd(int rtd) throws RcmException
    {
        if (rtd < 0 || rtd >= NUM_RTD_TEMPS) {
            throw new RcmException("Invalid temperature RTD number");
        }

        return 0F;
    }

}
