package org.lsst.ccs.drivers.rcm;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Image metadata
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class ImageMetadata implements Serializable {

   /**
    ***************************************************************************
    **
    **  Private data.
    **
    ***************************************************************************
    */
    protected long tag;     // The image tag
    protected int length;   // The number of pixels in the image data
    protected int format;   // The format of the data sent from the RCM
    protected int schema;   // The schema of the firmware producing the image
    protected int version;  // The version of the firmware producing the image
    protected int address;  // The address of the RCM producing the image
    protected int cluster;  // The cluster number of the RCE
    protected int element;  // The element number of the RCE


   /**
    ***************************************************************************
    **
    **  Constructors.
    **
    ***************************************************************************
    */
    public ImageMetadata()
    {
    }

    public ImageMetadata(long tag, int length, int format, int schema,
                         int version, int address, int cluster, int element)
    {
        this.tag = tag;
        this.length = length;
        this.format = format;
        this.schema = schema;
        this.version = version;
        this.address = address;
        this.cluster = cluster;
        this.element = element;
    }


   /**
    ***************************************************************************
    **
    **  Gets the image tag.
    **
    **  @return  The tag for the image
    **
    ***************************************************************************
    */
    public long getTag()
    {
        return tag;
    }


   /**
    ***************************************************************************
    **
    **  Gets the image length.
    **
    **  @return  The number of pixels in the image's pixel data.
    **
    ***************************************************************************
    */
    public int getLength()
    {
        return length;
    }


   /**
    ***************************************************************************
    **
    **  Gets the image format.
    **
    **  @return  The format (enumerated) of the data sent from the RCM.
    **
    ***************************************************************************
    */
    public int getFormat()
    {
        return format;
    }


   /**
    ***************************************************************************
    **
    **  Gets the firmware schema.
    **
    **  @return  The data schema of the firmware producing the image.
    **
    ***************************************************************************
    */
    public int getSchema()
    {
        return schema;
    }


   /**
    ***************************************************************************
    **
    **  Gets the firmware version.
    **
    **  @return  The version of the firmware producing the image.
    **
    ***************************************************************************
    */
    public int getVersion()
    {
        return version;
    }


   /**
    ***************************************************************************
    **
    **  Gets the RCM address.
    **
    **  @return  The address of the RCM producing the image.
    **
    ***************************************************************************
    */
    public int getAddress()
    {
        return address;
    }


   /**
    ***************************************************************************
    **
    **  Gets the CPU cluster number.
    **
    **  @return  The cluster number of the CPU (RCE) producing the image.
    **
    ***************************************************************************
    */
    public int getCluster()
    {
        return cluster;
    }


   /**
    ***************************************************************************
    **
    **  Gets the CPU element number.
    **
    **  @return  The element number of the CPU (RCE) producing the image.
    **
    ***************************************************************************
    */
    public int getElement()
    {
        return element;
    }


   /**
    ***************************************************************************
    **
    **  Gets the string representation.
    **
    **  @return  The string representation of the metadata
    **
    ***************************************************************************
    */
    @Override
    public String toString()
    {
        return String.format("Tag = %016x, Length = %s, Schema = %08x, "
                               + "Version = %08x, Address = %s, Cluster = %s, "
                               + "Element = %s",
                             tag, length, schema, version, address, cluster,
                             element);
    }

}
