/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import org.lsst.ccs.drivers.rcm.BaseSet;
import org.lsst.ccs.drivers.rcm.RcmException;
import org.lsst.ccs.drivers.rcm.RegClient;

public class Sequencer
extends BaseSet {
    public static final int REG_SEQ_LINES = 0x100000;
    public static final int REG_SEQ_TIMES = 0x200000;
    public static final int REG_SEQ_STACK = 0x300000;
    public static final int REG_SEQ_PROGRAM = 0x300000;
    public static final int REG_SEQ_STEP = 0x310000;
    public static final int REG_SEQ_STOP = 0x320000;
    public static final int REG_SEQ_SSIZE = 0x400000;
    public static final int REG_SEQ_NSLICE = 0x400005;
    public static final int REG_SEQ_SOURCE = 0x400006;
    public static final int REG_SEQ_BEB = 0x400007;
    public static final int REG_SEQ_STEP_0 = 0x500000;
    public static final int REG_SEQ_STOP_0 = 0x600000;
    public static final int SEQ_MAX_FUNC_0 = 4;
    public static final int SEQ_MAX_FUNC = 16;
    public static final int SEQ_MAX_SLICE = 16;
    public static final int SEQ_MAX_PROGRAM = 1024;
    public static final int SEQ_MAX_STACK = 4096;
    public static final int SEQ_SRC_FPGA_PTN = 0;
    public static final int SEQ_SRC_BEB_PTN = 7147;
    public static final int SEQ_SRC_BEB_ADC = 3051;
    public static final int SEQ_SRC_ADC = 0;
    public static final int SEQ_SRC_PATTERN = 1;
    public static final int SEQ_OPC_EXECUTE = 1;
    public static final int SEQ_OPC_JUMP = 2;
    public static final int SEQ_OPC_END_SUBR = 3;
    public static final int SEQ_OPC_END_PROG = 4;
    public static final int SEQ_PRG_V_OPCODE = 28;
    public static final int SEQ_PRG_V_FUNC = 24;
    public static final int SEQ_PRG_M_FUNC = 15;
    public static final int SEQ_PRG_V_LOOP = 23;
    public static final int SEQ_PRG_M_EXCCNT = 0x7FFFFF;
    public static final int SEQ_PRG_V_SUBADD = 18;
    public static final int SEQ_PRG_M_SUBADD = 1023;
    public static final int SEQ_PRG_M_SUBCNT = 131071;
    public static final int SEQ_STK_V_FUNC = 28;
    public static final int SEQ_STK_M_FUNC = 3;
    public static final int SEQ_STK_V_LOOP = 27;
    public static final int SEQ_STK_M_COUNT = 0x7FFFFFF;
    protected int[][] lines = new int[16][16];
    protected int[][] times = new int[16][16];
    protected int[] prog = new int[1024];
    protected int[] stack = new int[4096];
    protected int stackSize;

    public Sequencer(RegClient reg) {
        super(reg);
    }

    public Sequencer() {
    }

    @Override
    public void enable() throws RcmException {
        this.enable(2);
    }

    @Override
    public void disable() throws RcmException {
        this.disable(2);
    }

    public long getTriggerTime() throws RcmException {
        return this.getTriggerTime(2);
    }

    public void writeLines(int func, int slice, int value) throws RcmException {
        this.checkFunc(func);
        this.checkSlice(slice);
        this.write(0x100000 | func << 4 | slice, value);
        this.lines[func][slice] = value;
    }

    public void writeLines(int func, int[] values) throws RcmException {
        this.writeLines(func, values, 0, values.length);
    }

    public void writeLines(int func, int[] values, int offset, int count) throws RcmException {
        this.checkFunc(func);
        this.checkSlice(count - 1);
        this.write(0x100000 | func << 4, values, offset, count);
        System.arraycopy(values, offset, this.lines[func], 0, count);
    }

    public void writeTimes(int func, int slice, int value) throws RcmException {
        this.checkFunc(func);
        this.checkSlice(slice);
        this.write(0x200000 | func << 4 | slice, value);
        this.times[func][slice] = value;
    }

    public void writeTimes(int func, int[] values) throws RcmException {
        this.writeTimes(func, values, 0, values.length);
    }

    public void writeTimes(int func, int[] values, int offset, int count) throws RcmException {
        this.checkFunc(func);
        this.checkSlice(count - 1);
        this.write(0x200000 | func << 4, values, offset, count);
        System.arraycopy(values, offset, this.times[func], 0, count);
    }

    public void writeStack(int addr, int value) throws RcmException {
        this.checkVersion(0);
        this.checkStackAddr(addr);
        this.write(0x300000 + addr, value);
        this.stack[addr] = value;
    }

    public void writeStack(int addr, int[] values) throws RcmException {
        this.writeStack(addr, values, 0, values.length);
    }

    public void writeStack(int addr, int[] values, int offset, int count) throws RcmException {
        this.checkVersion(0);
        this.checkStackAddr(addr, count);
        this.write(0x300000 + addr, values, offset, count);
        System.arraycopy(values, offset, this.stack, addr, count);
    }

    public void writeStack(int[] values) throws RcmException {
        this.writeStack(values, 0, values.length);
    }

    public void writeStack(int[] values, int offset, int count) throws RcmException {
        this.checkVersion(0);
        this.checkStackAddr(0, count);
        this.write(0x300000, values, offset, count);
        this.write(0x400000, count);
        System.arraycopy(values, offset, this.stack, 0, count);
        this.stackSize = count;
    }

    public void writeStackSize(int value) throws RcmException {
        this.checkVersion(0);
        this.write(0x400000, value);
        this.stackSize = value;
    }

    public void writeProgram(int addr, int value) throws RcmException {
        this.checkNotVersion(0);
        this.checkProgAddr(addr);
        this.write(0x300000 + addr, value);
        this.prog[addr] = value;
    }

    public void writeProgram(int addr, int[] values) throws RcmException {
        this.writeProgram(addr, values, 0, values.length);
    }

    public void writeProgram(int addr, int[] values, int offset, int count) throws RcmException {
        this.checkNotVersion(0);
        this.checkProgAddr(addr, count);
        this.write(0x300000 + addr, values, offset, count);
        System.arraycopy(values, offset, this.prog, addr, count);
    }

    public void writeProgExec(int addr, int func, int count) throws RcmException {
        this.checkFunc(func);
        int value = count & 0x7FFFFF;
        if (count != -1 && count != value) {
            throw new RcmException("Invalid repetition count");
        }
        this.writeProgram(addr, value |= 0x10000000 | func << 24 | (count == -1 ? 0x800000 : 0));
    }

    public void writeProgJump(int addr, int subaddr, int count) throws RcmException {
        this.checkProgAddr(subaddr);
        int value = count & 0x1FFFF;
        if (count != value) {
            throw new RcmException("Invalid repetition count");
        }
        this.writeProgram(addr, value |= 0x20000000 | subaddr << 18);
    }

    public void writeProgEndSubr(int addr) throws RcmException {
        this.writeProgram(addr, 0x30000000);
    }

    public void writeProgEnd(int addr) throws RcmException {
        this.writeProgram(addr, 0x40000000);
    }

    public void writeSliceCount(int value) throws RcmException {
        this.write(0x400005, value);
    }

    public void writeDataSource(int value) throws RcmException {
        this.write(0x400006, value);
    }

    public void writeBebSelect(int value) throws RcmException {
        this.checkVersion(0);
        this.write(0x400007, value);
    }

    public void sendStep() throws RcmException {
        int stepAddr = this.getVersion() == 0 ? 0x500000 : 0x310000;
        this.write(stepAddr, 0);
    }

    public void sendStop() throws RcmException {
        int stopAddr = this.getVersion() == 0 ? 0x600000 : 0x320000;
        this.write(stopAddr, 0);
    }

    private void checkFunc(int func) throws RcmException {
        int maxFunc;
        int n = maxFunc = this.getVersion() == 0 ? 4 : 16;
        if (func < 0 || func >= maxFunc) {
            throw new RcmException("Invalid function number");
        }
    }

    private void checkSlice(int slice) throws RcmException {
        if (slice < 0 || slice >= 16) {
            throw new RcmException("Invalid time slice number");
        }
    }

    private void checkStackAddr(int addr) throws RcmException {
        if (addr < 0 || addr >= 4096) {
            throw new RcmException("Invalid stack address");
        }
    }

    private void checkStackAddr(int addr, int count) throws RcmException {
        if (addr < 0 || count <= 0 || addr + count > 4096) {
            throw new RcmException("Invalid stack address");
        }
    }

    private void checkProgAddr(int addr) throws RcmException {
        if (addr < 0 || addr >= 1024) {
            throw new RcmException("Invalid program address");
        }
    }

    private void checkProgAddr(int addr, int count) throws RcmException {
        if (addr < 0 || count <= 0 || addr + count > 1024) {
            throw new RcmException("Invalid program address");
        }
    }
}

