/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import org.lsst.ccs.drivers.rcm.RcmException;

public class RegClient {
    Handle handle = new Handle();

    static {
        System.loadLibrary("Rcm");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.deleteRegClient(this.handle.value);
    }

    public void open(int id) throws RcmException {
        if (this.handle.value != 0L) {
            throw new RcmException("Connection already open");
        }
        this.handle.value = this.newRegClient(id);
        ++this.handle.instance;
    }

    public void open(int id, String ifc) throws RcmException {
        if (this.handle.value != 0L) {
            throw new RcmException("Connection already open");
        }
        this.handle.value = ifc == null || ifc.length() == 0 ? this.newRegClient(id) : this.newRegClient2(id, ifc);
        ++this.handle.instance;
    }

    public void close() throws RcmException {
        this.checkOpen();
        this.deleteRegClient(this.handle.value);
        this.handle.value = 0L;
    }

    protected void checkOpen() throws RcmException {
        if (this.handle.value == 0L) {
            throw new RcmException("Connection not open");
        }
    }

    public int read(int address) throws RcmException {
        this.checkOpen();
        return this.readReg(this.handle.value, address);
    }

    public void read(int address, int[] values, int offset, int count) throws RcmException {
        this.checkOpen();
        this.readRegs(this.handle.value, address, values, offset, count);
    }

    public void read(int address, int[] values) throws RcmException {
        this.checkOpen();
        this.readRegs(this.handle.value, address, values, 0, values.length);
    }

    public void write(int address, int value) throws RcmException {
        this.checkOpen();
        this.writeReg(this.handle.value, address, value);
    }

    public void write(int address, int[] values, int offset, int count) throws RcmException {
        this.checkOpen();
        this.writeRegs(this.handle.value, address, values, offset, count);
    }

    public void write(int address, int[] values) throws RcmException {
        this.checkOpen();
        this.writeRegs(this.handle.value, address, values, 0, values.length);
    }

    public int update(int address, int mask, int value) throws RcmException {
        this.checkOpen();
        return this.updateReg(this.handle.value, address, mask, value);
    }

    public long readLong(int address) throws RcmException {
        this.checkOpen();
        int[] vals = new int[2];
        this.readRegs(this.handle.value, address, vals, 0, vals.length);
        return (long)vals[1] << 32 | (long)vals[0] & 0xFFFFFFFFL;
    }

    public void writeLong(int address, long value) throws RcmException {
        this.checkOpen();
        int[] vals = new int[]{(int)value, (int)(value >> 32)};
        this.writeRegs(this.handle.value, address, vals, 0, vals.length);
    }

    private native long newRegClient(int var1);

    private native long newRegClient2(int var1, String var2);

    private native void deleteRegClient(long var1);

    private native int readReg(long var1, int var3) throws RcmException;

    private native void readRegs(long var1, int var3, int[] var4, int var5, int var6) throws RcmException;

    private native void writeReg(long var1, int var3, int var4) throws RcmException;

    private native void writeRegs(long var1, int var3, int[] var4, int var5, int var6) throws RcmException;

    private native int updateReg(long var1, int var3, int var4, int var5) throws RcmException;

    class Handle {
        long value;
        int instance;

        Handle() {
        }
    }
}

