/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import org.lsst.ccs.drivers.rcm.RcmException;
import org.lsst.ccs.drivers.rcm.RegClient;

public class BaseSet
extends RegClient {
    public static final int RSET_STATUS = 0;
    public static final int RSET_TIME_BASE = 1;
    public static final int RSET_SEQUENCER = 2;
    public static final int RSET_POWER_ADCS = 3;
    public static final int RSET_TEMP_ADCS = 4;
    public static final int REG_SCHEMA = 0;
    public static final int REG_VERSION = 1;
    public static final int REG_ID = 2;
    public static final int REG_TIME_BASE = 4;
    public static final int REG_STATE = 8;
    public static final int REG_TRIGGER = 9;
    public static final int REG_TRIG_TIME = 10;
    public static final int VERSION_UNSET = -2;
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_0 = 0;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int CLOCK_PERIOD_0 = 5;
    public static final int CLOCK_PERIOD_1 = 10;
    private static final int WAIT_TIMEOUT = 1000;
    private int version = -2;
    private int handleInst;

    public BaseSet() {
    }

    public BaseSet(RegClient reg) {
        this.handle = reg.handle;
    }

    public int getVersion() throws RcmException {
        try {
            this.checkOpen();
        }
        catch (RcmException e) {
            this.version = -2;
            throw e;
        }
        if (this.version == -2 || this.handleInst != this.handle.instance) {
            this.handleInst = this.handle.instance;
            int schema = this.read(0);
            this.read(1);
            if (schema == 15851008) {
                this.version = 0;
            } else if (schema == 1) {
                this.version = 1;
            } else if (schema == 2) {
                this.version = 2;
            } else {
                this.version = -1;
                throw new RcmException("Unknown firmware version");
            }
        }
        return this.version;
    }

    public void checkVersion(int version) throws RcmException {
        if (this.getVersion() != version) {
            throw new RcmException("Incompatible firmware version");
        }
    }

    public void checkNotVersion(int version) throws RcmException {
        if (this.getVersion() == version) {
            throw new RcmException("Incompatible firmware version");
        }
    }

    public void enable() throws RcmException {
        this.enable(1);
    }

    public void disable() throws RcmException {
        this.disable(1);
    }

    public long getTimeRaw() throws RcmException {
        return this.readLong(4);
    }

    public long getTime() throws RcmException {
        return (long)this.getPeriod() * this.getTimeRaw() / 1000000L;
    }

    public void setTimeRaw(long time) throws RcmException {
        this.writeLong(4, time);
    }

    public void setTime(long time) throws RcmException {
        this.setTimeRaw(1000000L * time / (long)this.getPeriod());
    }

    public void setTime() throws RcmException {
        this.setTime(System.currentTimeMillis());
    }

    public void enable(int regSet) throws RcmException {
        this.write(9, this.read(8) & 3 | 1 << regSet);
    }

    public void disable(int regSet) throws RcmException {
        this.write(9, this.read(8) & 3 & ~(1 << regSet));
    }

    public void waitDone(int regSet) throws RcmException {
        long limit = System.currentTimeMillis() + 1000L;
        boolean busy = true;
        while (busy && System.currentTimeMillis() < limit) {
            boolean bl = busy = (this.read(8) & 1 << regSet) != 0;
        }
        if (busy) {
            throw new RcmException("Completion wait timeout");
        }
    }

    public long getTriggerTimeRaw(int regSet) throws RcmException {
        return this.readLong(10 + 2 * regSet);
    }

    public long getTriggerTime(int regSet) throws RcmException {
        return (long)this.getPeriod() * this.getTriggerTimeRaw(regSet) / 1000000L;
    }

    private int getPeriod() throws RcmException {
        return this.getVersion() == 0 ? 5 : 10;
    }
}

