/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.StringTokenizer;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.history.History;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.HelpGenerator;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.shell.CommandCompletionHandler;

public class JLineShell {
    private final CommandSet commands;
    private boolean exitRequested;
    private final ConsoleReader reader;
    private final PrintWriter printWriter;
    private CommandInvocationException lastException;

    public JLineShell(CommandSet userCommands) throws IOException {
        this(userCommands, new ConsoleReader());
    }

    public JLineShell(CommandSet userCommands, ConsoleReader reader) {
        this.reader = reader;
        reader.setPrompt(">>>");
        this.printWriter = new PrintWriter(reader.getOutput(), true);
        this.printWriter.println("Type help for list of available commands");
        CompositeCommandSet allCommands = new CompositeCommandSet();
        CommandSetBuilder builder = new CommandSetBuilder();
        allCommands.add(builder.buildCommandSet(new BuiltIns()));
        allCommands.add(userCommands);
        Dictionary commandDictionary = allCommands.getCommandDictionary();
        final DictionaryCompleter dictionaryCompleter = new DictionaryCompleter(commandDictionary);
        allCommands.add(builder.buildCommandSet(new HelpGenerator(this.printWriter, commandDictionary)));
        this.commands = allCommands;
        Completer completer = new Completer(){

            @Override
            public int complete(String string, int i, List<CharSequence> list) {
                return dictionaryCompleter.complete(string, i, list);
            }
        };
        reader.addCompleter(completer);
        reader.setCompletionHandler(new CommandCompletionHandler());
    }

    public void run() throws IOException {
        while (!this.exitRequested) {
            String command = this.reader.readLine();
            if (command == null) break;
            try {
                Object result;
                TokenizedCommand tc = new TokenizedCommand(command);
                if (tc.isEmpty() || (result = this.commands.invoke(tc)) == null) continue;
                this.reader.println("result=" + result);
            }
            catch (CommandInvocationException ex) {
                this.reader.println("Error: " + ex.getMessage());
                this.lastException = ex;
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        Options shellOptions = new Options();
        shellOptions.addOption("h", "help", false, "Print the help message");
        shellOptions.addOption("dc", "dictionaryClasses", true, "The comma separated list of classes to be used to build the command dictionary.\nThe dictionary classes must have an empty constructor in order to be loaded.");
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(shellOptions, argv, true);
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(100, "CommandShell", "", shellOptions, "", true);
        } else {
            CommandSetBuilder builder = new CommandSetBuilder();
            CompositeCommandSet compositeSet = new CompositeCommandSet();
            String dictionaryClasses = line.getOptionValue("dictionaryClasses");
            if (dictionaryClasses != null) {
                StringTokenizer classesTokenizer = new StringTokenizer(dictionaryClasses, ",");
                while (classesTokenizer.hasMoreTokens()) {
                    String className = classesTokenizer.nextToken();
                    try {
                        Class<?> c = Class.forName(className);
                        Object obj = c.newInstance();
                        compositeSet.add(builder.buildCommandSet(obj));
                    }
                    catch (Exception e) {
                        System.out.println("** Skipping class " + className + ". It could not be loaded or created.");
                        e.printStackTrace();
                    }
                }
            }
            JLineShell shell = new JLineShell(compositeSet);
            shell.run();
        }
    }

    public class BuiltIns {
        @Command(description="Exit from the shell")
        public void exit() {
            JLineShell.this.exitRequested = true;
        }

        @Command(description="Show command history")
        public void history() {
            History history = JLineShell.this.reader.getHistory();
            int i = 0;
            while (i < history.size()) {
                JLineShell.this.printWriter.printf("%3d: %s\n", i, history.get(i));
                ++i;
            }
        }

        @Command(description="Show the full stacktrace of the most recent error", alias="st")
        public void stacktrace() {
            if (JLineShell.this.lastException != null) {
                JLineShell.this.lastException.printStackTrace(JLineShell.this.printWriter);
            }
        }

        @Command(description="Modify various settings")
        public void set(@Argument(name="item") SetCommands what, @Argument(name="value") String value) {
            switch (what) {
                case prompt: {
                    JLineShell.this.reader.setPrompt(value);
                }
            }
        }
    }

    public static enum SetCommands {
        prompt;

    }
}

