/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.lsst.ccs.command.CommandInvocationException;

class InputConversionEngine {
    InputConversionEngine() {
    }

    Object convertArgToType(String arg, Class type) throws CommandInvocationException {
        try {
            if (type.equals(String.class) || type.isInstance(arg)) {
                return arg;
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return Integer.parseInt(arg);
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return Long.parseLong(arg);
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return Double.parseDouble(arg);
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return Float.valueOf(Float.parseFloat(arg));
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                if ("true".equalsIgnoreCase(arg)) {
                    return Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(arg)) {
                    return Boolean.FALSE;
                }
                throw new CommandInvocationException("Can't convert %s to Boolean", arg);
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, arg);
            }
            Constructor c = type.getConstructor(String.class);
            return c.newInstance(arg);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new CommandInvocationException("Error instantiating class %s using string %s", (Throwable)ex, type.getName(), arg);
        }
        catch (IllegalArgumentException | NoSuchMethodException e) {
            throw new CommandInvocationException("Can't convert string %s to class %s", (Throwable)e, arg, type.getName());
        }
    }
}

