/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.List;
import java.util.TreeSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryParameter;
import org.lsst.ccs.command.TokenizedCommand;

public class DictionaryCompleter {
    private final Dictionary dict;

    public DictionaryCompleter(Dictionary dict) {
        this.dict = dict;
    }

    public int complete(String buffer, int index, List<CharSequence> list) {
        TreeSet<String> set;
        boolean endsWithWhiteSpace;
        TokenizedCommand tc = new TokenizedCommand(buffer.substring(0, index));
        int argCount = tc.getArgumentCount();
        boolean bl = endsWithWhiteSpace = !tc.isEmpty() && Character.isWhitespace(buffer.charAt(index - 1));
        if (endsWithWhiteSpace) {
            ++argCount;
        }
        if (tc.isEmpty()) {
            set = new TreeSet<String>();
            for (DictionaryCommand def : this.dict) {
                String command = def.getCommandName();
                command = String.valueOf(command) + " ";
                set.add(command);
            }
        } else {
            if (argCount == 0) {
                String prefix = tc.getCommand();
                TreeSet<String> set2 = new TreeSet<String>();
                for (DictionaryCommand def : this.dict) {
                    String command = def.getCommandName();
                    if (!command.startsWith(prefix)) continue;
                    command = String.valueOf(command) + " ";
                    set2.add(command);
                }
                list.addAll(set2);
                return tc.getCommandIndex();
            }
            String command = tc.getCommand();
            String lastArg = endsWithWhiteSpace ? "" : tc.getArgument(argCount - 1);
            for (DictionaryCommand def : this.dict) {
                if (!command.equals(def.getCommandName()) || def.getParams().length < argCount && !def.isVarArgs()) continue;
                DictionaryParameter currentArg = def.getParams()[Math.min(argCount, def.getParams().length) - 1];
                List<String> values = currentArg.getValues();
                if (values.isEmpty()) {
                    list.add("# " + currentArg.getName() + " " + currentArg.getType() + " " + currentArg.getDescription());
                    continue;
                }
                for (String value : values) {
                    if (!value.startsWith(lastArg)) continue;
                    value = String.valueOf(value) + " ";
                    list.add(value);
                }
            }
            return endsWithWhiteSpace ? index : tc.getArgumentIndex(argCount - 1);
        }
        list.addAll(set);
        return index;
    }
}

