/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.lsst.ccs.utilities.logging.IsLoggableDelegate;
import org.lsst.ccs.utilities.tracers.Tracer;

public class FileHandlerN
extends FileHandler {
    protected IsLoggableDelegate isLoggableDelegate = new IsLoggableDelegate();
    protected IsLoggableDelegate isLoggableDelegate2 = new IsLoggableDelegate();
    private static final int offValue = Level.OFF.intValue();

    public FileHandlerN() throws IOException, SecurityException {
    }

    public FileHandlerN(String pattern) throws IOException, SecurityException {
        super(pattern);
    }

    public FileHandlerN(String pattern, boolean append) throws IOException, SecurityException {
        super(pattern, append);
    }

    public FileHandlerN(String pattern, int limit, int count) throws IOException, SecurityException {
        super(pattern, limit, count);
    }

    public FileHandlerN(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        super(pattern, limit, count, append);
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        boolean res = super.isLoggable(record);
        if (!res) {
            return false;
        }
        boolean delegateVal = this.isLoggableDelegate.isLoggable(record);
        if (delegateVal) {
            return true;
        }
        assert (Tracer.trace(record + " loggable ? " + res));
        return this.isLoggableDelegate2.isLoggable(record);
    }

    private boolean handlerLoggable(LogRecord record) {
        int levelValue = this.getLevel().intValue();
        if (record.getLevel().intValue() < levelValue || levelValue == offValue) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.isLoggable(record);
    }

    @Override
    public void publish(LogRecord record) {
        assert (Tracer.trace("record to be written :" + record.getMessage()));
        super.publish(record);
    }
}

