/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import org.lsst.ccs.drivers.rcm.BaseSet;
import org.lsst.ccs.drivers.rcm.RcmException;
import org.lsst.ccs.drivers.rcm.RegClient;

public class PowerAdcs
extends BaseSet {
    public static final int REG_POWER_ADCS = 0x600000;
    public static final int ADC_V6_VOLTAGE = 0;
    public static final int ADC_V6_CURRENT = 1;
    public static final int ADC_V9_VOLTAGE = 2;
    public static final int ADC_V9_CURRENT = 3;
    public static final int ADC_V24_VOLTAGE = 4;
    public static final int ADC_V24_CURRENT = 5;
    public static final int ADC_V40_VOLTAGE = 6;
    public static final int ADC_V40_CURRENT = 7;
    public static final int NUM_POWER_REGS = 8;
    public static final float VOLTAGE_SCALE = 0.0015625f;
    public static final float CURRENT_SCALE = 1.5625E-6f;

    public PowerAdcs() {
    }

    public PowerAdcs(RegClient reg) {
        super(reg);
    }

    @Override
    public void enable() throws RcmException {
        this.checkNotVersion(0);
        this.enable(3);
    }

    public void waitDone() throws RcmException {
        this.checkNotVersion(0);
        this.waitDone(3);
    }

    public long getTriggerTime() throws RcmException {
        this.checkVersion(2);
        return this.getTriggerTime(3);
    }

    public float readAdc(int adc) throws RcmException {
        if (adc < 0 || adc >= 8) {
            throw new RcmException("Invalid power ADC number");
        }
        this.enable();
        this.waitDone();
        return ((adc & 1) == 0 ? 0.0015625f : 1.5625E-6f) * (float)this.read(0x600000 + adc);
    }

    public float[] readAdcs() throws RcmException {
        return this.readAdcs(0, 8);
    }

    public float[] readAdcs(int first, int count) throws RcmException {
        if (first < 0 || count < 0 || first + count > 8) {
            throw new RcmException("Invalid power ADC range");
        }
        this.enable();
        this.waitDone();
        int[] rawData = new int[count];
        float[] data = new float[count];
        this.read(0x600000 + first, rawData);
        int j = 0;
        while (j < count) {
            data[j] = ((first + j & 1) == 0 ? 0.0015625f : 1.5625E-6f) * (float)rawData[j];
            ++j;
        }
        return data;
    }
}

