/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import org.lsst.ccs.drivers.rcm.Image;
import org.lsst.ccs.drivers.rcm.RcmException;

public class ImageClient {
    private static final int RUNNING = 0;
    private static final int CLOSING = 1;
    private static final int ENDING = 2;
    private long client;
    private long subscriber;
    private ReadThread reader;
    private Listener imgListener;
    private Image listenImage;

    static {
        System.loadLibrary("Rcm");
        ImageClient.initSys();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.deleteImageClient();
    }

    public void open(int id) throws RcmException {
        if (this.client != 0L) {
            throw new RcmException("Connection already open");
        }
        this.newImageClient(id);
        if (this.imgListener != null) {
            this.reader = new ReadThread(this.imgListener, this.listenImage);
            this.reader.setDaemon(true);
            this.reader.start();
        }
    }

    public void close() throws RcmException {
        this.checkOpen();
        if (this.reader == null) {
            this.deleteImageClient();
        } else {
            this.reader.setState(1);
            this.reader = null;
        }
    }

    public Image awaitImage(Image image) throws RcmException {
        this.checkOpen();
        return this.waitForImage(image);
    }

    public boolean readImage(Image image) throws RcmException {
        this.checkOpen();
        return this.getImage(image);
    }

    public static native void deleteImageMetadataRef(Image var0);

    public void setListener(Listener listener, Image image) {
        if (this.reader != null) {
            this.reader.setState(2);
            this.reader = null;
        }
        this.imgListener = listener;
        this.listenImage = image;
        if (this.client != 0L) {
            this.reader = new ReadThread(listener, image);
            this.reader.setDaemon(true);
            this.reader.start();
        }
    }

    public void clearListener() {
        if (this.reader != null) {
            this.reader.setState(2);
            this.reader = null;
        }
        this.imgListener = null;
        this.listenImage = null;
    }

    private static native void initSys();

    private native void newImageClient(int var1);

    private native void deleteImageClient();

    public native Image waitForImage(Image var1);

    public native boolean getImage(Image var1);

    private void checkOpen() throws RcmException {
        if (this.client == 0L) {
            throw new RcmException("Connection not open");
        }
    }

    public static interface Listener {
        public void processImage(Image var1);
    }

    public class ReadThread
    extends Thread {
        Listener listener;
        Image listenImage;
        int state = 0;

        public ReadThread(Listener lstnr, Image image) {
            this.listener = lstnr;
            this.listenImage = image;
        }

        @Override
        public void run() {
            while (this.state == 0) {
                Image image = ImageClient.this.waitForImage(this.listenImage);
                if (this.state != 0) break;
                ImageClient.this.getImage(image);
                Listener l = this.listener;
                if (this.state != 0) break;
                l.processImage(image);
            }
            if (this.state == 1) {
                ImageClient.this.deleteImageClient();
            }
        }

        public void setState(int newState) {
            this.state = newState;
        }
    }
}

