/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import org.lsst.ccs.shell.CLIException;
import org.lsst.ccs.shell.ShellCommandParamSpec;

public abstract class ShellCommand {
    private String prefix;
    private String name;
    private String description;
    private String abbreviation;
    private String header;
    private ShellCommandParamSpec[] paramSpecs;
    private boolean isVarArgs = false;

    public ShellCommand(String prefix, String name) {
        this.prefix = prefix;
        this.name = name;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public abstract Object invoke(Object[] var1) throws CLIException;

    public boolean canBeDenotedBy(String commandName) {
        return commandName.equals(String.valueOf(this.prefix) + this.name) || commandName.equals(String.valueOf(this.prefix) + this.abbreviation);
    }

    public int getArity() {
        return this.paramSpecs.length;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public boolean startsWith(String prefix) {
        return (String.valueOf(this.prefix) + this.abbreviation).startsWith(prefix) || (String.valueOf(this.prefix) + this.name).startsWith(prefix);
    }

    public String toString() {
        return String.valueOf(this.prefix) + this.name + "\t" + (this.abbreviation != null ? String.valueOf(this.prefix) + this.abbreviation : "") + "\t" + this.paramSpecs.length + (this.isVarArgs() ? "+" : "") + "\t" + this.description;
    }

    public String getHeader() {
        return this.header;
    }

    public ShellCommandParamSpec[] getParamSpecs() {
        return this.paramSpecs;
    }

    public Class[] getParameterTypes() {
        Class[] types = new Class[this.paramSpecs.length];
        int count = 0;
        ShellCommandParamSpec[] shellCommandParamSpecArray = this.paramSpecs;
        int n = this.paramSpecs.length;
        int n2 = 0;
        while (n2 < n) {
            ShellCommandParamSpec spec = shellCommandParamSpecArray[n2];
            types[count++] = spec.getValueClass();
            ++n2;
        }
        return types;
    }

    public void setParamSpecs(ShellCommandParamSpec[] paramSpecs) {
        this.paramSpecs = paramSpecs;
    }
}

