/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.lsst.ccs.shell.OutputConverter;

public class OutputConversionEngine {
    private List<OutputConverter> outputConverters = new ArrayList<OutputConverter>();

    public void addConverter(OutputConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException("Converter == null");
        }
        this.outputConverters.add(converter);
    }

    public boolean removeConverter(OutputConverter converter) {
        return this.outputConverters.remove(converter);
    }

    public Object convertOutput(Object anObject) {
        Object convertedOutput = anObject;
        ListIterator<OutputConverter> it = this.outputConverters.listIterator(this.outputConverters.size());
        while (it.hasPrevious()) {
            OutputConverter outputConverter = it.previous();
            Object conversionResult = outputConverter.convertOutput(convertedOutput);
            if (conversionResult == null) continue;
            convertedOutput = conversionResult;
        }
        return convertedOutput;
    }

    public void addDeclaredConverters(Object handler) {
        Field[] fields;
        Field[] fieldArray = fields = handler.getClass().getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().startsWith("CLI_OUTPUT_CONVERTERS") && field.getType().isArray() && OutputConverter.class.isAssignableFrom(field.getType().getComponentType())) {
                try {
                    Object convertersArray = field.get(handler);
                    int i = 0;
                    while (i < Array.getLength(convertersArray)) {
                        this.addConverter((OutputConverter)Array.get(convertersArray, i));
                        ++i;
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error getting converter from field " + field.getName(), ex);
                }
            }
            ++n2;
        }
    }
}

