/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rcm;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.rcm.BaseSet;
import org.lsst.ccs.drivers.rcm.Image;
import org.lsst.ccs.drivers.rcm.ImageClient;
import org.lsst.ccs.drivers.rcm.RcmException;
import org.lsst.ccs.drivers.rcm.RegClient;
import org.lsst.ccs.utilities.sa.CmndProcess;

public class TestImage
implements CmndProcess.Dispatch,
ImageClient.Listener {
    private static final int CMD_CONNECT = 0;
    private static final int CMD_DISPLAY = 1;
    private static final int CMD_REGION = 2;
    private static final int CMD_LISTEN = 3;
    private static final int CMD_WAIT = 4;
    private static final int CMD_READ = 5;
    private static final int CMD_METADATA = 6;
    private static final int CMD_DISCONN = 7;
    private static final int NUM_CMDS = 8;
    private static final String[] helpConnect = new String[]{"Connect to an RCM", "connect <id>", "id    The id of the RCM"};
    private static final String[] helpDisconn = new String[]{"Disconnect from an RCM", "disconnect"};
    private static final String[] helpListen = new String[]{"Enable or disable the image listener", "listen <action> [<newbuff>] [<time>]", "action   The action to perform: 'on' to enable; 'off' to disable", "newbuff  If present (any value), use a new image buffer each time", "time     If present (any value), show image acquisition times"};
    private static final String[] helpWait = new String[]{"Wait for an image to arrive", "wait [<newbuff>] [<time>]", "newbuff  If present (any value), allocate a new image buffer", "time     If present (any value), show image acquisition time"};
    private static final String[] helpRead = new String[]{"Read image data", "read [<time>]", "time  If present (any value), show image read time"};
    private static final String[] helpDisplay = new String[]{"Display selected data from the last image received", "display <count> [<offset>]", "count   The number of pixels to display", "offset  The offset of the first pixel to display (default 0)"};
    private static final String[] helpMetadata = new String[]{"Display the metadata from the last image received", "metadata"};
    private static final String[] helpRegion = new String[]{"Set the region to be displayed automatically from each received image", "region [<count>] [<offset>]", "count   The number of pixels to display (initially 0)", "offset  The offset of the first pixel to display (initially 0)"};
    private static final CmndProcess.Lookup onoffNames = new CmndProcess.Lookup(2);
    private static final CmndProcess.Command cmnd;
    private static final PrintStream out;
    private final CmndProcess proc = new CmndProcess();
    private final ImageClient imc = new ImageClient();
    private final RegClient reg = new RegClient();
    private final BaseSet bset = new BaseSet(this.reg);
    private int rcmId = 0;
    private int imgLength = -1;
    private int imgOffset = 0;
    private boolean imgOkay;
    private boolean listening = false;
    private boolean listenTime = false;
    private Image image;

    static {
        onoffNames.add("on", 1);
        onoffNames.add("off", 0);
        cmnd = new CmndProcess.Command(8);
        cmnd.add("connect", 0, helpConnect, "I", new CmndProcess.Lookup[0]);
        cmnd.add("disconn", 7, helpDisconn, "", new CmndProcess.Lookup[0]);
        cmnd.add("listen", 3, helpListen, "Kss", new CmndProcess.Lookup[]{onoffNames});
        cmnd.add("wait", 4, helpWait, "ss", new CmndProcess.Lookup[0]);
        cmnd.add("read", 5, helpRead, "s", new CmndProcess.Lookup[0]);
        cmnd.add("display", 1, helpDisplay, "Ii", new CmndProcess.Lookup[0]);
        cmnd.add("metadata", 6, helpMetadata, "", new CmndProcess.Lookup[0]);
        cmnd.add("region", 2, helpRegion, "ii", new CmndProcess.Lookup[0]);
        out = System.out;
    }

    public static void main(String[] args) {
        new TestImage().run();
        System.exit(0);
    }

    public void run() {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        try {
            String line;
            ConsoleReader reader = new ConsoleReader();
            while ((line = reader.readLine(">> ")) != null && this.proc.process(line)) {
            }
        }
        catch (IOException e) {
            out.println(e);
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        try {
            switch (code) {
                case 0: {
                    this.procConnect(found, args);
                    break;
                }
                case 7: {
                    this.procDisconn(found, args);
                    break;
                }
                case 3: {
                    this.procListen(found, args);
                    break;
                }
                case 4: {
                    this.procWait(found, args);
                    break;
                }
                case 5: {
                    this.procRead(found, args);
                    break;
                }
                case 1: {
                    this.procDisplay(found, args);
                    break;
                }
                case 6: {
                    this.procMetadata(found, args);
                    break;
                }
                case 2: {
                    this.procRegion(found, args);
                    break;
                }
                default: {
                    out.println("Command not fully implemented");
                    break;
                }
            }
        }
        catch (RcmException e) {
            out.println(e);
        }
        return true;
    }

    private void procConnect(int found, Object[] args) throws RcmException {
        this.rcmId = (Integer)args[0];
        this.imc.open(this.rcmId);
        this.reg.open(this.rcmId);
    }

    private void procDisconn(int found, Object[] args) throws RcmException {
        this.imc.close();
        this.reg.close();
    }

    private void procListen(int found, Object[] args) {
        if (!this.checkConnect()) {
            return;
        }
        if ((Integer)args[0] != 0) {
            this.listening = true;
            this.listenTime = (found & 4) != 0;
            this.imc.setListener(this, (found & 2) != 0 ? null : this.image);
        } else {
            this.listening = false;
            this.imc.clearListener();
        }
    }

    private void procWait(int found, Object[] args) throws RcmException {
        if (!this.checkConnect() || !this.checkListen()) {
            return;
        }
        this.image = this.imc.awaitImage((found & 1) != 0 ? null : this.image);
        if ((found & 2) != 0) {
            long currTime = this.bset.getTime();
            long trigTime = this.bset.getTriggerTime(2);
            out.format("Elapsed time = %s msec\n", currTime - trigTime);
        }
        this.displayMetadata(this.image, "Got metadata", false);
    }

    private void procRead(int found, Object[] args) throws RcmException {
        if (!this.checkConnect() || !this.checkListen()) {
            return;
        }
        long start = System.currentTimeMillis();
        this.imgOkay = this.imc.readImage(this.image);
        if (found != 0) {
            out.format("Elapsed time = %s msec\n", System.currentTimeMillis() - start);
        }
        if (!this.imgOkay) {
            out.println("Error reading image data");
        }
    }

    private void procDisplay(int found, Object[] args) {
        if (this.image == null) {
            out.println("No image stored");
        } else {
            int offset = (found & 2) != 0 ? (Integer)args[1] : 0;
            this.displayImage(this.image, offset, (Integer)args[0]);
        }
    }

    private void procMetadata(int found, Object[] args) {
        if (this.image == null) {
            out.println("No image stored");
        } else {
            this.displayMetadata(this.image, "Metadata", true);
        }
    }

    private void procRegion(int found, Object[] args) {
        if (found == 0) {
            out.format("Display region: length = %s, offset = %s\n", this.imgLength, this.imgOffset);
        } else {
            if ((found & 1) != 0) {
                this.imgLength = (Integer)args[0];
            }
            if ((found & 2) != 0) {
                this.imgOffset = (Integer)args[1];
            }
        }
    }

    @Override
    public void processImage(Image img) {
        this.image = img;
        if (this.listenTime) {
            try {
                long currTime = this.bset.getTime();
                long trigTime = this.bset.getTriggerTime(2);
                out.format("Elapsed time = %s msec\n", currTime - trigTime);
            }
            catch (RcmException rcmException) {}
        }
        this.displayMetadata(this.image, "Got image", true);
        if (this.image.getData() != null) {
            this.displayImage(this.image, this.imgOffset, this.imgLength);
        }
    }

    private void displayMetadata(Image img, String caption, boolean showValid) {
        StringBuilder blanks = new StringBuilder(caption.length());
        int j = 0;
        while (j < caption.length()) {
            blanks.append(" ");
            ++j;
        }
        Object[] objectArray = new Object[10];
        objectArray[0] = caption;
        objectArray[1] = this.image.getTag();
        objectArray[2] = this.image.getLength();
        objectArray[3] = this.image.getSchema();
        objectArray[4] = blanks;
        objectArray[5] = this.image.getVersion();
        objectArray[6] = this.image.getAddress();
        objectArray[7] = this.image.getCluster();
        objectArray[8] = this.image.getElement();
        objectArray[9] = showValid ? (this.image.getData() != null ? ", valid" : ", invalid") : "";
        out.format("%s: tag = %016x, length = %s, schema = %08x,\n%s  version = %08x, address = %s, cluster = %s, element = %s%s\n", objectArray);
    }

    private void displayImage(Image img, int offset, int count) {
        if (count < 0) {
            return;
        }
        ByteBuffer buff = img.getData();
        if (buff == null) {
            out.println("Image contains no valid data");
            return;
        }
        offset = offset < 0 ? 0 : offset;
        int iCount = img.getLength() / 4;
        if (count == 0 || count + offset > iCount) {
            count = iCount - offset;
        }
        if (count <= 0) {
            return;
        }
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.position(4 * offset);
        int j = 0;
        while (j < count) {
            if ((j & 3) == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%08x:", offset + j);
            }
            out.format(" %08x", buff.getInt());
            ++j;
        }
        out.println();
    }

    private boolean checkConnect() {
        boolean okay;
        boolean bl = okay = this.imc != null;
        if (!okay) {
            out.println("No RCM connected");
        }
        return okay;
    }

    private boolean checkListen() {
        boolean okay;
        boolean bl = okay = !this.listening;
        if (!okay) {
            out.println("Listener is active");
        }
        return okay;
    }
}

