/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.pmcard;

import org.lsst.ccs.drivers.pmcard.PMCard;
import org.lsst.ccs.drivers.pmcard.PMCardException;

public class TIUCD90xxx
extends PMCard {
    static final int TYPE_VOLT = 0;
    static final int TYPE_CURR = 1;
    static final int TYPE_TEMP = 2;
    int currentRail = -1;

    public TIUCD90xxx(int devPort, int devAddr) throws PMCardException {
        this.open(devPort, devAddr);
    }

    public TIUCD90xxx() throws PMCardException {
    }

    public void open(int devPort, int devAddr) throws PMCardException {
        int nmax = 1;
        short[] ports = new short[]{-1};
        int nDev = 0;
        boolean found = false;
        int rc = 0;
        nDev = super.getPorts(nmax, ports);
        if (nDev <= 0) {
            throw new PMCardException("No device port found");
        }
        int i = 0;
        while (i < nDev) {
            if (ports[i] == devPort) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            throw new PMCardException("No device port found with devPort=" + String.valueOf(devPort));
        }
        rc = super.setOpen(devPort);
        if (rc < 0) {
            throw new PMCardException("Could not open device port with devPort=" + String.valueOf(devPort));
        }
        rc = super.setAddr(devAddr);
        if (rc < 0) {
            throw new PMCardException("Could not open device with devAddr=" + String.valueOf(devAddr));
        }
    }

    public void setDevRail(int devRail) throws PMCardException {
        if (devRail == this.currentRail) {
            return;
        }
        int rc = 0;
        rc = super.setRail(devRail);
        if (rc < 0) {
            throw new PMCardException("Could not set rail to devRail=" + String.valueOf(devRail));
        }
        this.currentRail = devRail;
    }

    public double getParmValue(int devRail, int type) throws PMCardException {
        double value;
        this.setDevRail(devRail);
        switch (type) {
            case 0: {
                value = super.getVOut();
                break;
            }
            case 1: {
                value = super.getIOut();
                break;
            }
            case 2: {
                value = super.getTemp();
                break;
            }
            default: {
                throw new PMCardException("Invalid type");
            }
        }
        if (value < 0.0) {
            value = 0.0;
            throw new PMCardException("Failed to get value of parameter, setting to 0.0");
        }
        return value;
    }

    public void getParmLimits(int devRail, int type, double[] limits) throws PMCardException {
        this.setDevRail(devRail);
        int rc = 0;
        rc = super.getLimits(type, limits);
        if (rc < 0) {
            throw new PMCardException("Failed to get limits of parameter");
        }
    }
}

