package org.lsst.ccs.drivers.pmcard;

import org.lsst.ccs.drivers.pmcard.PMCardException;

/**
 ***************************************************************************
 **
 **  \file  TIUCD90xxx.java
 **
 **  Access a Texas Instruments UCD90xxx power management device
 **
 **  @author Xiaowen Lei
 **
 ***************************************************************************
 */
public class TIUCD90xxx extends PMCard {

   /**
    ***************************************************************************
    **
    **  Various constants
    **
    ***************************************************************************
    */
    final static int
        TYPE_VOLT = 0,
        TYPE_CURR = 1,
        TYPE_TEMP = 2;

   /**
    ***************************************************************************
    **
    **  Private data
    **
    ***************************************************************************
    */
    int currentRail=-1;


   /**
    ***************************************************************************
    **
    **  Constructors
    **
    ***************************************************************************
    */
    public TIUCD90xxx(int devPort, int devAddr)
        throws PMCardException
    {
        open(devPort, devAddr);
    }


    public TIUCD90xxx()
        throws PMCardException
    {
    }


   /**
    ***************************************************************************
    **
    **  Opens device connection
    **
    ***************************************************************************
    */
    public void open(int devPort, int devAddr)
        throws PMCardException
    {
        int nmax=1;
        short ports[]={-1};
        int nDev=0;
        boolean found=false;
        int rc=0;

        nDev=super.getPorts(nmax, ports);
        if (nDev<=0)
            throw new PMCardException("No device port found");
        for (int i=0; i<nDev; i++) {
            if (ports[i]==devPort) {
                found = true;
                continue;
            }
        }
        if (!found)
            throw new PMCardException("No device port found with devPort="+String.valueOf(devPort));
        rc=super.setOpen(devPort);
        if (rc<0)
            throw new PMCardException("Could not open device port with devPort="+String.valueOf(devPort));
        rc=super.setAddr(devAddr);
        if (rc<0)
            throw new PMCardException("Could not open device with devAddr="+String.valueOf(devAddr));
    }

    
  /**
    ***************************************************************************
    **
    **  Chooses rail
    **
    ***************************************************************************
    */
    public void setDevRail(int devRail)
        throws PMCardException
    {
        if (devRail==currentRail)
            return;

        int rc=0;
        rc=super.setRail(devRail);
        if (rc<0)
            throw new PMCardException("Could not set rail to devRail="+String.valueOf(devRail));

        currentRail=devRail;
    }


  /**
    ***************************************************************************
    **
    **  Gets parameter value
    **
    ***************************************************************************
    */
    public double getParmValue(int devRail, int type)
        throws PMCardException
    {
        setDevRail(devRail);

        double value;
        switch (type) {
            case TYPE_VOLT:
                value = super.getVOut();
                break;
            case TYPE_CURR:
                value = super.getIOut();
                break;
            case TYPE_TEMP:
                value = super.getTemp();
                break;
            default:
                throw new PMCardException("Invalid type");
        }
        if (value<0.0) {
            value=0.0;
            throw new PMCardException("Failed to get value of parameter, setting to 0.0");
        }
        return value;
    }


  /**
    ***************************************************************************
    **
    **  Gets parameter limits
    **
    ***************************************************************************
    */
    public void getParmLimits(int devRail, int type, double limits[])
        throws PMCardException
    {
        setDevRail(devRail);

        int rc=0;
        rc = super.getLimits(type, limits);
        if (rc < 0)
            throw new PMCardException("Failed to get limits of parameter");
    }

}
