package org.lsst.ccs.drivers.pmcard;

/**
 ***************************************************************************
 **
 **  \file  PMCard.java
 **
 **  Java interface to the PMCard routines
 **
 **  \author Xiaowen Lei
 **
 ***************************************************************************
 */
public class PMCard {

   /**
    ***************************************************************************
    **
    ** Various constants
    **
    ***************************************************************************
    */


  /**
    ***************************************************************************
    **
    ** Private data
    **
    ***************************************************************************
    */


   /**
    ***************************************************************************
    **
    **  Static initializer
    **
    ***************************************************************************
    */
    static {
        System.loadLibrary("PMCard");
        //initSys();
    }


   /**
    ***************************************************************************
    **
    **  Initialize system access
    **
    ***************************************************************************
    */
    //private native static void initSys();


   /**
    ***************************************************************************
    **
    **  Diagnostic printing
    **  Set system print
    **
    ***************************************************************************
    **/
    public native int setPrint(int sysprt);


   /**
    ***************************************************************************
    **  Adaptor access
    **  get ports for adaptors
    **
    ***************************************************************************
    */
    public native int getPorts(int nMax, short[] ports);


   /**
    ***************************************************************************
    **
    **  Open the adaptor
    **
    ***************************************************************************
    */
    public native int setOpen(int port);


   /**
    ***************************************************************************
    **
    **  Close the adaptor
    **
    ***************************************************************************
    */
    public native int setClose();


   /**
    ***************************************************************************
    **
    **  PS address
    **  Set PS address
    **
    ***************************************************************************
    */
    public native int setAddr(int addr);


   /**
    ***************************************************************************
    **
    **  PS address
    **  Get PS address
    **
    ***************************************************************************
    */
    public native int getAddr();


   /**
    ***************************************************************************
    **
    **  PS page
    **  Set PS page
    **
    ***************************************************************************
    */
    public native int setPage(	int page);


   /**
    ***************************************************************************
    **
    **  PS page
    **  Get PS page
    **
    ***************************************************************************
    */
    public native int getPage();


   /**
    ***************************************************************************
    **
    **  PS rail
    **  Set PS rail
    **
    ***************************************************************************
    */
    public native int setRail(int rail);


   /**
    ***************************************************************************
    **
    **  PS rail
    **  Get PS rail
    **
    ***************************************************************************
    */
    public native int getRail();


   /**
    ***************************************************************************
    **
    **  Clear PS faults
    **
    ***************************************************************************
    */
    public native int clearFaults();		//clear faults


   /**
    ***************************************************************************
    **
    **  Read PS status
    **
    ***************************************************************************
    */
    public native int getStatus(byte[] status);


   /**
    ***************************************************************************
    **
    **  Read PS temperature
    **
    ***************************************************************************
    */
    public native double getTemp();


   /**
    ***************************************************************************
    **
    **  Read rail output voltage
    **
    ***************************************************************************
    */
    public native double getVOut();


   /**
    ***************************************************************************
    **
    **  Read rail output current
    **
    ***************************************************************************
    */
    public native double getIOut();


   /**
    ***************************************************************************
    **
    **  Parameters limits
    **  Get parm limits
    **
    ***************************************************************************
    */
    public native int getLimits(int type, double[] Data);


   /**
    ***************************************************************************
    **
    **  Free the bus
    **
    ***************************************************************************
    */
    public native int i2cFree();


   /**
    ***************************************************************************
    **
    **  Set bus timeout
    **
    ***************************************************************************
    */
    public native int i2cSetTimeout(short Timeout);


   /**
    ***************************************************************************
    **
    **  Set bus bitrate
    **
    ***************************************************************************
    */
    public native int i2cSetBitrate(int Bitrate);


   /**
    ***************************************************************************
    **
    **  Write 
    **
    ***************************************************************************
    */
    public native int i2cWrite(short nBytes, byte[] Data);


   /**
    ***************************************************************************
    **
    **  WriteRead
    **
    ***************************************************************************
    */
    public native int i2cWriteRead( short nOut,
                                    byte[] outData,
                                    short[]nWritten,
                                    short nIn,
                                    byte[] inData,
                                    short[] nRead);


   /**
    ***************************************************************************
    **
    **  JNI data flow test
    **
    ***************************************************************************
    */
    public native String JNITest( String s,
                                  int i32,
                                  int[] a32,
                                  short i16,
                                  short[] a16,
                                  byte[] b8,
                                  byte[] a8);
}
