/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.pluto;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.modbus.Modbus;
import org.lsst.ccs.drivers.modbus.TestModbus;
import org.lsst.ccs.drivers.pluto.Pluto;

public class TestPluto
extends TestModbus {
    private final Pluto plu;

    public TestPluto() {
        super((Modbus)new Pluto());
        this.plu = (Pluto)this.mod;
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="node", description="Network node name") String node) throws DriverException {
        this.plu.open(node);
    }

    @Command(name="showstatus", description="Show the module status")
    public void showStatus() throws DriverException {
        this.out.format("Node status = 0x%08x\n", this.plu.readModuleStatus());
    }

    @Command(name="readglobal", description="Read global data")
    public void readGlobal(@Argument(name="pluto", description="Pluto ID") int pluto) throws DriverException {
        this.out.format("Value = 0x%08x\n", this.plu.readGlobalData(pluto));
    }

    @Command(name="readadditional", description="Read additional data")
    public void readAdditional(@Argument(name="area", description="Area number") int area) throws DriverException {
        this.out.format("Value = 0x%08x\n", this.plu.readAdditionalData(area));
    }

    @Command(name="configstart", description="Start a configuration")
    public void readAdditional(@Argument(name="nodemask", description="Bit mask of nodes") int nodeMask, @Argument(name="areamask", description="Bit mask of areas") int areaMask, @Argument(name="timeout", description="To Pluto timeout (ms)") int timeout, @Argument(name="cycletime", description="To Pluto cycle time") int cycleTime) {
        this.plu.configStart(nodeMask, areaMask, timeout, cycleTime);
    }

    @Command(name="configarea", description="Configure a data area")
    public void configArea(@Argument(name="area", description="Data area number") int area, @Argument(name="pluto", description="Pluto number") int pluto, @Argument(name="dataid", description="Data ID") int dataId) {
        this.plu.configDataArea(area, pluto, dataId);
    }

    @Command(name="configwrite", description="Write the configutation")
    public void configWrite() throws DriverException {
        this.plu.configWrite();
    }

    @Command(name="writebit", description="Write a bit to an area")
    public void writeBit(@Argument(name="area", description="Data area number") int area, @Argument(name="bit", description="Bit number") int bit, @Argument(name="value", description="Bit value") int value) throws DriverException {
        this.plu.writeAreaBit(area, bit, value);
    }

    @Command(name="writeregister", description="Write a register to an area")
    public void writeRegister(@Argument(name="area", description="Data area number") int area, @Argument(name="register", description="Register number") int reg, @Argument(name="value", description="Register value") int value) throws DriverException {
        this.plu.writeAreaRegister(area, reg, value);
    }

    @Command(name="readlocal", description="Read local data")
    public void readLocal(@Argument(name="pluto", description="Pluto ID") int pluto, @Argument(name="type", description="Data type") int type, @Argument(name="address", description="Data address") int addr) throws DriverException {
        this.readLocal(pluto, type, addr, 1);
    }

    @Command(name="readlocal", description="Read local data")
    public void readLocal(@Argument(name="pluto", description="Pluto ID") int pluto, @Argument(name="type", description="Data type") int type, @Argument(name="address", description="Data address") int addr, @Argument(name="count", description="Number of addresses") int count) throws DriverException {
        String sep = "";
        for (int j = 0; j < count; ++j) {
            try {
                int value = this.plu.readLocalData(pluto, type, addr + j);
                if ((j & 3) == 0) {
                    this.out.format("%s%4s:", sep, addr + j);
                    sep = "\n";
                }
                this.out.format(" %08x", value);
                Thread.sleep(j < count - 1 ? 500L : 0L);
                continue;
            }
            catch (DriverException e) {
                if (j > 0) {
                    this.out.println();
                }
                throw e;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (count > 0) {
            this.out.println();
        }
    }
}

